/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.List;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryState;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class TrajectoryStateHistoryWriter
extends AbstractWriter {
    private final TrajectoryStateHistory history;
    private final TimeConverter timeConverter;

    TrajectoryStateHistoryWriter(TrajectoryStateHistory trajectoryStateHistory, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.traj.name(), OcmDataSubStructureKey.TRAJ.name());
        this.history = trajectoryStateHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        TrajectoryStateHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_ID.name(), metadata.getTrajID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_PREV_ID.name(), metadata.getTrajPrevID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_NEXT_ID.name(), metadata.getTrajNextID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_BASIS.name(), metadata.getTrajBasis(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_BASIS_ID.name(), metadata.getTrajBasisID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.INTERPOLATION.name(), metadata.getInterpolationMethod(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.INTERPOLATION_DEGREE.name(), metadata.getInterpolationDegree(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.ORB_AVERAGING.name(), metadata.getOrbAveraging(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.CENTER_NAME.name(), metadata.getCenter().getName(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_REF_FRAME.name(), metadata.getTrajReferenceFrame().getName(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_FRAME_EPOCH.name(), this.timeConverter, metadata.getTrajFrameEpoch(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.USEABLE_START_TIME.name(), this.timeConverter, metadata.getUseableStartTime(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.USEABLE_STOP_TIME.name(), this.timeConverter, metadata.getUseableStopTime(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.ORB_REVNUM.name(), metadata.getOrbRevNum(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.ORB_REVNUM_BASIS.name(), metadata.getOrbRevNumBasis(), false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_TYPE.name(), metadata.getTrajType(), true);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_UNITS.name(), generator.unitsListToString(metadata.getTrajUnits()), null, false);
        List<Unit> units = metadata.getTrajType().getUnits();
        for (TrajectoryState state : this.history.getTrajectoryStates()) {
            double[] elements = state.getElements();
            StringBuilder line = new StringBuilder();
            line.append(generator.dateToString(this.timeConverter, state.getDate()));
            for (int i = 0; i < units.size(); ++i) {
                line.append(' ');
                line.append(AccurateFormatter.format(units.get(i).fromSI(elements[i])));
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("trajLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }
}

