/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.utils.ParameterDriversList;

public class KalmanModel
extends AbstractKalmanModel {
    public KalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        super(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix, new JacobiansMapper[propagatorBuilders.size()]);
    }

    @Override
    protected void updateReferenceTrajectories(Propagator[] propagators, PropagationType pType, PropagationType sType) {
        this.setReferenceTrajectories(propagators);
        MatricesHarvester[] harvesters = new MatricesHarvester[propagators.length];
        for (int k = 0; k < propagators.length; ++k) {
            String equationName = KalmanEstimator.class.getName() + "-derivatives-" + k;
            harvesters[k] = this.getReferenceTrajectories()[k].setupMatricesComputation(equationName, null, null);
        }
        this.setHarvesters(harvesters);
    }
}

