/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.carlson.FieldDuplication;
import org.hipparchus.util.FastMath;

class RfFieldDuplication<T extends CalculusFieldElement<T>>
extends FieldDuplication<T> {
    RfFieldDuplication(T x, T y, T z) {
        super(new CalculusFieldElement[]{x, y, z});
    }

    @Override
    protected void initialMeanPoint(T[] va) {
        va[3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)va[0].add(va[1])).add(va[2])).divide(3.0);
    }

    @Override
    protected T convergenceCriterion(T r, T max) {
        return (T)max.divide((CalculusFieldElement)FastMath.sqrt(FastMath.sqrt(FastMath.sqrt((CalculusFieldElement)r.multiply(3.0)))));
    }

    @Override
    protected void update(int m, T[] vaM, T[] sqrtM, double fourM) {
        CalculusFieldElement lambdaA = (CalculusFieldElement)sqrtM[0].multiply(sqrtM[1]);
        CalculusFieldElement lambdaB = (CalculusFieldElement)sqrtM[0].multiply(sqrtM[2]);
        CalculusFieldElement lambdaC = (CalculusFieldElement)sqrtM[1].multiply(sqrtM[2]);
        vaM[0] = vaM[0].linearCombination(0.25, vaM[0], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[1] = vaM[1].linearCombination(0.25, vaM[1], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[2] = vaM[2].linearCombination(0.25, vaM[2], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[3] = vaM[3].linearCombination(0.25, vaM[3], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
    }

    @Override
    protected T evaluate(T[] va0, T aM, double fourM) {
        CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)aM.multiply(fourM)).reciprocal();
        CalculusFieldElement bigX = ((CalculusFieldElement)va0[3].subtract(va0[0])).multiply(inv);
        CalculusFieldElement bigY = ((CalculusFieldElement)va0[3].subtract(va0[1])).multiply(inv);
        CalculusFieldElement bigZ = (CalculusFieldElement)bigX.add(bigY).negate();
        CalculusFieldElement e2 = bigX.multiply(bigY).subtract(bigZ.multiply(bigZ));
        CalculusFieldElement e3 = bigX.multiply(bigY).multiply(bigZ);
        CalculusFieldElement e2e2 = e2.multiply(e2);
        CalculusFieldElement e2e3 = e2.multiply(e3);
        CalculusFieldElement e3e3 = e3.multiply(e3);
        CalculusFieldElement e2e2e2 = e2e2.multiply(e2);
        CalculusFieldElement poly = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2e2e2.multiply(-5775.0)).add(e3e3.multiply(6930.0))).add(e2e3.multiply(-16380.0))).add(e2e2.multiply(10010.0))).add(e3.multiply(17160.0))).add(e2.multiply(-24024.0))).add(240240.0)).divide(240240.0);
        return (T)((CalculusFieldElement)poly.divide(FastMath.sqrt(aM)));
    }

    @Override
    public T integral() {
        Object x = this.getVi(0);
        Object y = this.getVi(1);
        Object z = this.getVi(2);
        if (x.isZero()) {
            return this.completeIntegral(y, z);
        }
        if (y.isZero()) {
            return this.completeIntegral(x, z);
        }
        if (z.isZero()) {
            return this.completeIntegral(x, y);
        }
        return super.integral();
    }

    private T completeIntegral(T x, T y) {
        CalculusFieldElement yM1;
        CalculusFieldElement xM1;
        CalculusFieldElement xM = (CalculusFieldElement)x.sqrt();
        CalculusFieldElement yM = (CalculusFieldElement)y.sqrt();
        for (int i = 1; i < 32 && !((xM = (CalculusFieldElement)(xM1 = xM).add(yM1 = yM).multiply(0.5)).subtract(yM = (CalculusFieldElement)xM1.multiply(yM1).sqrt()).norm() <= 4.0 * FastMath.ulp(xM).getReal()); ++i) {
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)xM.add(yM).reciprocal()).multiply(xM.getPi()));
    }
}

