/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class EclipseDetector
extends AbstractDetector<EclipseDetector> {
    private final OneAxisEllipsoid occulting;
    private final PVCoordinatesProvider occulted;
    private final double occultedRadius;
    private final boolean totalEclipse;

    public EclipseDetector(PVCoordinatesProvider occulted, double occultedRadius, OneAxisEllipsoid occulting) {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), occulted, occultedRadius, occulting, true);
    }

    private EclipseDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super EclipseDetector> handler, PVCoordinatesProvider occulted, double occultedRadius, OneAxisEllipsoid occulting, boolean totalEclipse) {
        super(maxCheck, threshold, maxIter, handler);
        this.occulted = occulted;
        this.occultedRadius = FastMath.abs((double)occultedRadius);
        this.occulting = occulting;
        this.totalEclipse = totalEclipse;
    }

    @Override
    protected EclipseDetector create(double newMaxCheck, double newThreshold, int nawMaxIter, EventHandler<? super EclipseDetector> newHandler) {
        return new EclipseDetector(newMaxCheck, newThreshold, nawMaxIter, newHandler, this.occulted, this.occultedRadius, this.occulting, this.totalEclipse);
    }

    public EclipseDetector withUmbra() {
        return new EclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occulted, this.occultedRadius, this.occulting, true);
    }

    public EclipseDetector withPenumbra() {
        return new EclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occulted, this.occultedRadius, this.occulting, false);
    }

    public OneAxisEllipsoid getOcculting() {
        return this.occulting;
    }

    public PVCoordinatesProvider getOcculted() {
        return this.occulted;
    }

    public double getOccultedRadius() {
        return this.occultedRadius;
    }

    public boolean getTotalEclipse() {
        return this.totalEclipse;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D pted = this.occulted.getPVCoordinates(s.getDate(), this.occulting.getBodyFrame()).getPosition();
        Vector3D psat = s.getPVCoordinates(this.occulting.getBodyFrame()).getPosition();
        Vector3D plimb = this.occulting.pointOnLimb(psat, pted);
        Vector3D ps = psat.subtract((Vector)pted);
        Vector3D pi = psat.subtract((Vector)plimb);
        double angle = Vector3D.angle((Vector3D)ps, (Vector3D)psat);
        double rs = FastMath.asin((double)(this.occultedRadius / ps.getNorm()));
        if (Double.isNaN(rs)) {
            return Math.PI;
        }
        double ro = Vector3D.angle((Vector3D)pi, (Vector3D)psat);
        return this.totalEclipse ? angle - ro + rs : angle - ro - rs;
    }
}

