/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorConverter;
import org.orekit.propagation.conversion.NumericalPropagatorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeStampedPVCoordinates;

public class JacobianPropagatorConverter
extends AbstractPropagatorConverter {
    private final NumericalPropagatorBuilder builder;

    public JacobianPropagatorConverter(NumericalPropagatorBuilder builder, double threshold, int maxIterations) {
        super(builder, threshold, maxIterations);
        if (builder.getOrbitType() != OrbitType.CARTESIAN) {
            throw new OrekitException((Localizable)OrekitMessages.ORBIT_TYPE_NOT_ALLOWED, new Object[]{builder.getOrbitType(), OrbitType.CARTESIAN});
        }
        this.builder = builder;
    }

    @Override
    protected MultivariateVectorFunction getObjectiveFunction() {
        return point -> {
            NumericalPropagator propagator = this.builder.buildPropagator(point);
            ValuesHandler handler = new ValuesHandler();
            propagator.getMultiplexer().add(handler);
            List<SpacecraftState> sample = this.getSample();
            propagator.propagate(sample.get(sample.size() - 1).getDate().shiftedBy(10.0));
            return handler.value;
        };
    }

    @Override
    protected MultivariateJacobianFunction getModel() {
        return point -> {
            NumericalPropagator propagator = this.builder.buildPropagator(point.toArray());
            JacobianHandler handler = new JacobianHandler(propagator, point.getDimension());
            propagator.getMultiplexer().add(handler);
            List<SpacecraftState> sample = this.getSample();
            propagator.propagate(sample.get(sample.size() - 1).getDate().shiftedBy(10.0));
            return new Pair((Object)handler.value, (Object)handler.jacobian);
        };
    }

    private class JacobianHandler
    implements OrekitStepHandler {
        private final RealVector value;
        private final RealMatrix jacobian;
        private final int stateSize;
        private final MatricesHarvester harvester;
        private int number;
        private int index;

        JacobianHandler(NumericalPropagator propagator, int columns) {
            this.value = new ArrayRealVector(JacobianPropagatorConverter.this.getTargetSize());
            this.jacobian = MatrixUtils.createRealMatrix((int)JacobianPropagatorConverter.this.getTargetSize(), (int)columns);
            this.stateSize = JacobianPropagatorConverter.this.isOnlyPosition() ? 3 : 6;
            this.harvester = propagator.setupMatricesComputation("converter-partials", null, null);
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target) {
            this.number = 0;
            this.index = 0;
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            while (this.number < JacobianPropagatorConverter.this.getSample().size()) {
                SpacecraftState next = JacobianPropagatorConverter.this.getSample().get(this.number);
                AbsoluteDate currentDate = interpolator.getCurrentState().getDate();
                if (next.getDate().compareTo(currentDate) > 0) {
                    return;
                }
                this.fillRows(this.index, interpolator.getInterpolatedState(next.getDate()), JacobianPropagatorConverter.this.builder.getOrbitalParametersDrivers());
                ++this.number;
                this.index += this.stateSize;
            }
        }

        private void fillRows(int row, SpacecraftState state, ParameterDriversList orbitalParameters) {
            TimeStampedPVCoordinates pv = state.getPVCoordinates(JacobianPropagatorConverter.this.getFrame());
            this.value.setEntry(row, pv.getPosition().getX());
            this.value.setEntry(row + 1, pv.getPosition().getY());
            this.value.setEntry(row + 2, pv.getPosition().getZ());
            if (!JacobianPropagatorConverter.this.isOnlyPosition()) {
                this.value.setEntry(row + 3, pv.getVelocity().getX());
                this.value.setEntry(row + 4, pv.getVelocity().getY());
                this.value.setEntry(row + 5, pv.getVelocity().getZ());
            }
            RealMatrix dYdY0 = this.harvester.getStateTransitionMatrix(state);
            RealMatrix dYdP = this.harvester.getParametersJacobian(state);
            for (int k = 0; k < this.stateSize; ++k) {
                int j;
                int column = 0;
                for (j = 0; j < orbitalParameters.getNbParams(); ++j) {
                    ParameterDriver driver = orbitalParameters.getDrivers().get(j);
                    if (!driver.isSelected()) continue;
                    this.jacobian.setEntry(row + k, column++, dYdY0.getEntry(k, j) * driver.getScale());
                }
                if (dYdP == null) continue;
                for (j = 0; j < dYdP.getColumnDimension(); ++j) {
                    String name = this.harvester.getJacobiansColumnsNames().get(j);
                    for (ParameterDriver parameterDriver : JacobianPropagatorConverter.this.builder.getPropagationParametersDrivers().getDrivers()) {
                        if (!name.equals(parameterDriver.getName())) continue;
                        this.jacobian.setEntry(row + k, column++, dYdP.getEntry(k, j) * parameterDriver.getScale());
                    }
                }
            }
        }
    }

    private class ValuesHandler
    implements OrekitStepHandler {
        private final double[] value;
        private int number;
        private int index;

        ValuesHandler() {
            this.value = new double[JacobianPropagatorConverter.this.getTargetSize()];
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target) {
            this.number = 0;
            this.index = 0;
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            while (this.number < JacobianPropagatorConverter.this.getSample().size()) {
                SpacecraftState next = JacobianPropagatorConverter.this.getSample().get(this.number);
                AbsoluteDate currentDate = interpolator.getCurrentState().getDate();
                if (next.getDate().compareTo(currentDate) > 0) {
                    return;
                }
                TimeStampedPVCoordinates pv = interpolator.getInterpolatedState(next.getDate()).getPVCoordinates(JacobianPropagatorConverter.this.getFrame());
                this.value[this.index++] = pv.getPosition().getX();
                this.value[this.index++] = pv.getPosition().getY();
                this.value[this.index++] = pv.getPosition().getZ();
                if (!JacobianPropagatorConverter.this.isOnlyPosition()) {
                    this.value[this.index++] = pv.getVelocity().getX();
                    this.value[this.index++] = pv.getVelocity().getY();
                    this.value[this.index++] = pv.getVelocity().getZ();
                }
                ++this.number;
            }
        }
    }
}

