/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.stream.Stream;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PythonOrbit
extends Orbit {
    private long pythonObject;

    public void pythonExtension(long pythonObject) {
        this.pythonObject = pythonObject;
    }

    public long pythonExtension() {
        return this.pythonObject;
    }

    public void finalize() throws Throwable {
        this.pythonDecRef();
    }

    public native void pythonDecRef();

    public PythonOrbit(Frame frame, AbsoluteDate date, double mu) throws IllegalArgumentException {
        super(frame, date, mu);
    }

    public PythonOrbit(TimeStampedPVCoordinates pvCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
    }

    @Override
    public native OrbitType getType();

    @Override
    public native double getA();

    @Override
    public native double getADot();

    @Override
    public native double getEquinoctialEx();

    @Override
    public native double getEquinoctialExDot();

    @Override
    public native double getEquinoctialEy();

    @Override
    public native double getEquinoctialEyDot();

    @Override
    public native double getHx();

    @Override
    public native double getHxDot();

    @Override
    public native double getHy();

    @Override
    public native double getHyDot();

    @Override
    public native double getLE();

    @Override
    public native double getLEDot();

    @Override
    public native double getLv();

    @Override
    public native double getLvDot();

    @Override
    public native double getLM();

    @Override
    public native double getLMDot();

    @Override
    public native double getE();

    @Override
    public native double getEDot();

    @Override
    public native double getI();

    @Override
    public native double getIDot();

    @Override
    public native TimeStampedPVCoordinates initPVCoordinates();

    @Override
    public native Orbit shiftedBy(double var1);

    @Override
    protected native double[][] computeJacobianMeanWrtCartesian();

    @Override
    protected native double[][] computeJacobianEccentricWrtCartesian();

    @Override
    protected native double[][] computeJacobianTrueWrtCartesian();

    @Override
    public native void addKeplerContribution(PositionAngle var1, double var2, double[] var4);

    @Override
    public native Orbit interpolate(AbsoluteDate var1, Stream<Orbit> var2);
}

