/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.TimeStampedGenerator;

public class FieldTransformGenerator<T extends CalculusFieldElement<T>>
implements TimeStampedGenerator<FieldTransform<T>> {
    private final Field<T> field;
    private int neighborsSize;
    private final TransformProvider provider;
    private final double step;

    public FieldTransformGenerator(Field<T> field, int neighborsSize, TransformProvider provider, double step) {
        this.field = field;
        this.neighborsSize = neighborsSize;
        this.provider = provider;
        this.step = step;
    }

    @Override
    public List<FieldTransform<T>> generate(AbsoluteDate existingDate, AbsoluteDate date) {
        FieldAbsoluteDate<T> fieldDate = new FieldAbsoluteDate<T>(this.field, date);
        ArrayList<FieldTransform<T>> generated = new ArrayList<FieldTransform<T>>();
        if (existingDate == null) {
            for (int i = 0; i < this.neighborsSize; ++i) {
                generated.add(this.provider.getTransform(fieldDate.shiftedBy((double)i * this.step)));
            }
        } else {
            TimeShiftable<FieldAbsoluteDate<T>> t = new FieldAbsoluteDate<T>(this.field, existingDate);
            if (date.compareTo(((FieldAbsoluteDate)t).toAbsoluteDate()) > 0) {
                do {
                    t = ((FieldAbsoluteDate)t).shiftedBy(this.step);
                    generated.add(generated.size(), this.provider.getTransform(t));
                } while (((FieldAbsoluteDate)t).compareTo(fieldDate) <= 0);
            } else {
                do {
                    t = ((FieldAbsoluteDate)t).shiftedBy(-this.step);
                    generated.add(0, this.provider.getTransform(t));
                } while (((FieldAbsoluteDate)t).compareTo(fieldDate) >= 0);
            }
        }
        return generated;
    }
}

