/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.files.ccsds.definitions.ElementsType;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.oem.InterpolationMethod;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

public class TrajectoryStateHistoryMetadata
extends CommentsContainer {
    private String trajID;
    private String trajPrevID;
    private String trajNextID;
    private String trajBasis = "PREDICTED";
    private String trajBasisID;
    private InterpolationMethod interpolationMethod = InterpolationMethod.HERMITE;
    private int interpolationDegree = 3;
    private String orbAveraging = "OSCULATING";
    private BodyFacade center;
    private FrameFacade trajReferenceFrame;
    private AbsoluteDate trajFrameEpoch;
    private AbsoluteDate useableStartTime;
    private AbsoluteDate useableStopTime;
    private int orbRevNum;
    private int orbRevNumBasis;
    private ElementsType trajType;
    private List<Unit> trajUnits;

    TrajectoryStateHistoryMetadata(AbsoluteDate epochT0, DataContext dataContext) {
        this.center = new BodyFacade("EARTH", dataContext.getCelestialBodies().getEarth());
        this.trajReferenceFrame = new FrameFacade(dataContext.getFrames().getICRF(), CelestialBodyFrame.ICRF, null, null, CelestialBodyFrame.ICRF.name());
        this.trajFrameEpoch = epochT0;
        this.trajType = ElementsType.CARTPV;
        this.orbRevNum = -1;
        this.orbRevNumBasis = -1;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (this.trajUnits != null) {
            this.trajType.checkUnits(this.trajUnits);
        }
        if (this.orbRevNum >= 0 && this.orbRevNumBasis < 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, TrajectoryStateHistoryMetadataKey.ORB_REVNUM_BASIS.name());
        }
    }

    public String getTrajID() {
        return this.trajID;
    }

    public void setTrajID(String trajID) {
        this.refuseFurtherComments();
        this.trajID = trajID;
    }

    public String getTrajPrevID() {
        return this.trajPrevID;
    }

    public void setTrajPrevID(String trajPrevID) {
        this.refuseFurtherComments();
        this.trajPrevID = trajPrevID;
    }

    public String getTrajNextID() {
        return this.trajNextID;
    }

    public void setTrajNextID(String trajNextID) {
        this.refuseFurtherComments();
        this.trajNextID = trajNextID;
    }

    public String getTrajBasis() {
        return this.trajBasis;
    }

    public void setTrajBasis(String trajBasis) {
        this.refuseFurtherComments();
        this.trajBasis = trajBasis;
    }

    public String getTrajBasisID() {
        return this.trajBasisID;
    }

    public void setTrajBasisID(String trajBasisID) {
        this.refuseFurtherComments();
        this.trajBasisID = trajBasisID;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(InterpolationMethod interpolationMethod) {
        this.refuseFurtherComments();
        this.interpolationMethod = interpolationMethod;
    }

    public int getInterpolationDegree() {
        return this.interpolationDegree;
    }

    public void setInterpolationDegree(int interpolationDegree) {
        this.refuseFurtherComments();
        this.interpolationDegree = interpolationDegree;
    }

    public String getOrbAveraging() {
        return this.orbAveraging;
    }

    public void setOrbAveraging(String orbAveraging) {
        this.refuseFurtherComments();
        this.orbAveraging = orbAveraging;
    }

    public BodyFacade getCenter() {
        return this.center;
    }

    public void setCenter(BodyFacade center) {
        this.refuseFurtherComments();
        this.center = center;
    }

    public FrameFacade getTrajReferenceFrame() {
        return this.trajReferenceFrame;
    }

    public void setTrajReferenceFrame(FrameFacade trajReferenceFrame) {
        this.refuseFurtherComments();
        this.trajReferenceFrame = trajReferenceFrame;
    }

    public AbsoluteDate getTrajFrameEpoch() {
        return this.trajFrameEpoch;
    }

    public void setTrajFrameEpoch(AbsoluteDate trajFrameEpoch) {
        this.refuseFurtherComments();
        this.trajFrameEpoch = trajFrameEpoch;
    }

    public AbsoluteDate getUseableStartTime() {
        return this.useableStartTime;
    }

    public void setUseableStartTime(AbsoluteDate useableStartTime) {
        this.refuseFurtherComments();
        this.useableStartTime = useableStartTime;
    }

    public AbsoluteDate getUseableStopTime() {
        return this.useableStopTime;
    }

    public void setUseableStopTime(AbsoluteDate useableStopTime) {
        this.refuseFurtherComments();
        this.useableStopTime = useableStopTime;
    }

    public int getOrbRevNum() {
        return this.orbRevNum;
    }

    public void setOrbRevNum(int orbRevNum) {
        this.orbRevNum = orbRevNum;
    }

    public int getOrbRevNumBasis() {
        return this.orbRevNumBasis;
    }

    public void setOrbRevNumBasis(int orbRevNumBasis) {
        this.orbRevNumBasis = orbRevNumBasis;
    }

    public ElementsType getTrajType() {
        return this.trajType;
    }

    public void setTrajType(ElementsType trajType) {
        this.refuseFurtherComments();
        this.trajType = trajType;
    }

    public List<Unit> getTrajUnits() {
        return this.trajUnits;
    }

    public void setTrajUnits(List<Unit> trajUnits) {
        this.refuseFurtherComments();
        this.trajUnits = trajUnits;
    }
}

