/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyLoader;
import org.orekit.bodies.LazyLoadedCelestialBodies;
import org.orekit.data.DataContext;

public class CelestialBodyFactory {
    public static final String SOLAR_SYSTEM_BARYCENTER = "solar system barycenter";
    public static final String SUN = "Sun";
    public static final String MERCURY = "Mercury";
    public static final String VENUS = "Venus";
    public static final String EARTH_MOON = "Earth-Moon barycenter";
    public static final String EARTH = "Earth";
    public static final String MOON = "Moon";
    public static final String MARS = "Mars";
    public static final String JUPITER = "Jupiter";
    public static final String SATURN = "Saturn";
    public static final String URANUS = "Uranus";
    public static final String NEPTUNE = "Neptune";
    public static final String PLUTO = "Pluto";

    private CelestialBodyFactory() {
    }

    @DefaultDataContext
    public static LazyLoadedCelestialBodies getCelestialBodies() {
        return DataContext.getDefault().getCelestialBodies();
    }

    @DefaultDataContext
    public static void addCelestialBodyLoader(String name, CelestialBodyLoader loader) {
        CelestialBodyFactory.getCelestialBodies().addCelestialBodyLoader(name, loader);
    }

    @DefaultDataContext
    public static void addDefaultCelestialBodyLoader(String supportedNames) {
        CelestialBodyFactory.getCelestialBodies().addDefaultCelestialBodyLoader(supportedNames);
    }

    @DefaultDataContext
    public static void addDefaultCelestialBodyLoader(String name, String supportedNames) {
        CelestialBodyFactory.getCelestialBodies().addDefaultCelestialBodyLoader(name, supportedNames);
    }

    @DefaultDataContext
    public static void clearCelestialBodyLoaders(String name) {
        CelestialBodyFactory.getCelestialBodies().clearCelestialBodyLoaders(name);
    }

    @DefaultDataContext
    public static void clearCelestialBodyLoaders() {
        CelestialBodyFactory.getCelestialBodies().clearCelestialBodyLoaders();
    }

    @DefaultDataContext
    public static void clearCelestialBodyCache(String name) {
        CelestialBodyFactory.getCelestialBodies().clearCelestialBodyCache(name);
    }

    @DefaultDataContext
    public static void clearCelestialBodyCache() {
        CelestialBodyFactory.getCelestialBodies().clearCelestialBodyCache();
    }

    @DefaultDataContext
    public static CelestialBody getSolarSystemBarycenter() {
        return CelestialBodyFactory.getCelestialBodies().getSolarSystemBarycenter();
    }

    @DefaultDataContext
    public static CelestialBody getSun() {
        return CelestialBodyFactory.getCelestialBodies().getSun();
    }

    @DefaultDataContext
    public static CelestialBody getMercury() {
        return CelestialBodyFactory.getCelestialBodies().getMercury();
    }

    @DefaultDataContext
    public static CelestialBody getVenus() {
        return CelestialBodyFactory.getCelestialBodies().getVenus();
    }

    @DefaultDataContext
    public static CelestialBody getEarthMoonBarycenter() {
        return CelestialBodyFactory.getCelestialBodies().getEarthMoonBarycenter();
    }

    @DefaultDataContext
    public static CelestialBody getEarth() {
        return CelestialBodyFactory.getCelestialBodies().getEarth();
    }

    @DefaultDataContext
    public static CelestialBody getMoon() {
        return CelestialBodyFactory.getCelestialBodies().getMoon();
    }

    @DefaultDataContext
    public static CelestialBody getMars() {
        return CelestialBodyFactory.getCelestialBodies().getMars();
    }

    @DefaultDataContext
    public static CelestialBody getJupiter() {
        return CelestialBodyFactory.getCelestialBodies().getJupiter();
    }

    @DefaultDataContext
    public static CelestialBody getSaturn() {
        return CelestialBodyFactory.getCelestialBodies().getSaturn();
    }

    @DefaultDataContext
    public static CelestialBody getUranus() {
        return CelestialBodyFactory.getCelestialBodies().getUranus();
    }

    @DefaultDataContext
    public static CelestialBody getNeptune() {
        return CelestialBodyFactory.getCelestialBodies().getNeptune();
    }

    @DefaultDataContext
    public static CelestialBody getPluto() {
        return CelestialBodyFactory.getCelestialBodies().getPluto();
    }

    @DefaultDataContext
    public static CelestialBody getBody(String name) {
        return CelestialBodyFactory.getCelestialBodies().getBody(name);
    }
}

