/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.hipparchus.util.FastMath;

class FieldBigParameter<T extends CalculusFieldElement<T>>
extends FieldJacobiElliptic<T> {
    private final FieldJacobiElliptic<T> algorithm;
    private final T inputScale;
    private final T outputScale;

    FieldBigParameter(T m) {
        super(m);
        this.algorithm = JacobiEllipticBuilder.build((CalculusFieldElement)m.reciprocal());
        this.inputScale = FastMath.sqrt(m);
        this.outputScale = (CalculusFieldElement)this.inputScale.reciprocal();
    }

    @Override
    public FieldCopolarN<T> valuesN(T u) {
        FieldCopolarN<CalculusFieldElement> trioN = this.algorithm.valuesN((CalculusFieldElement)u.multiply(this.inputScale));
        return new FieldCopolarN<CalculusFieldElement>(this.outputScale.multiply((CalculusFieldElement)trioN.sn()), trioN.dn(), trioN.cn());
    }
}

