/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.BaseAbstractFieldUnivariateIntegrator;
import org.hipparchus.analysis.integration.gauss.FieldGaussIntegrator;
import org.hipparchus.analysis.integration.gauss.FieldGaussIntegratorFactory;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class IterativeLegendreFieldGaussIntegrator<T extends CalculusFieldElement<T>>
extends BaseAbstractFieldUnivariateIntegrator<T> {
    private final FieldGaussIntegratorFactory<T> factory;
    private final int numberOfPoints;

    public IterativeLegendreFieldGaussIntegrator(Field<T> field, int n, double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (n <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, n);
        }
        this.factory = new FieldGaussIntegratorFactory<T>(field);
        this.numberOfPoints = n;
    }

    public IterativeLegendreFieldGaussIntegrator(Field<T> field, int n, double relativeAccuracy, double absoluteAccuracy) throws MathIllegalArgumentException {
        this(field, n, relativeAccuracy, absoluteAccuracy, 3, Integer.MAX_VALUE);
    }

    public IterativeLegendreFieldGaussIntegrator(Field<T> field, int n, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        this(field, n, 1.0E-6, 1.0E-15, minimalIterationCount, maximalIterationCount);
    }

    @Override
    protected T doIntegrate() throws MathIllegalArgumentException, MathIllegalStateException {
        T oldt = this.stage(1);
        int n = 2;
        while (true) {
            T t = this.stage(n);
            double delta = FastMath.abs((CalculusFieldElement)t.subtract(oldt)).getReal();
            double limit = FastMath.max(this.getAbsoluteAccuracy(), ((CalculusFieldElement)((CalculusFieldElement)FastMath.abs(oldt).add(FastMath.abs(t))).multiply(0.5 * this.getRelativeAccuracy())).getReal());
            if (this.iterations.getCount() + 1 >= this.getMinimalIterationCount() && delta <= limit) {
                return t;
            }
            double ratio = FastMath.min(4.0, FastMath.pow(delta / limit, 0.5 / (double)this.numberOfPoints));
            n = FastMath.max((int)(ratio * (double)n), n + 1);
            oldt = t;
            this.iterations.increment();
        }
    }

    private T stage(int n) throws MathIllegalStateException {
        int min = this.getMin();
        int max = this.getMax();
        CalculusFieldElement step = (CalculusFieldElement)((CalculusFieldElement)max.subtract(min)).divide(n);
        CalculusFieldElement sum = (CalculusFieldElement)this.getField().getZero();
        for (int i = 0; i < n; ++i) {
            CalculusFieldElement a = (CalculusFieldElement)min.add(step.multiply(i));
            CalculusFieldElement b = a.add(step);
            FieldGaussIntegrator<CalculusFieldElement> g = this.factory.legendre(this.numberOfPoints, a, b);
            sum = sum.add(g.integrate(x$0 -> super.computeObjectiveValue(x$0)));
        }
        return (T)sum;
    }
}

