
import os
if hasattr(os, 'add_dll_directory'):
  for location in (('bin', 'client'),('bin', 'server'),('jre', 'bin', 'client'),('jre', 'bin', 'server')):
    path = os.path.join(os.environ['JAVA_HOME'], *location)
    if os.path.exists(os.path.join(path, 'jvm.dll')):
      os.add_dll_directory(path)
      break
from . import _orekit

__module_dir__ = os.path.abspath(os.path.dirname(__file__))

class JavaError(Exception):
  def getJavaException(self):
    return self.args[0]
  def __str__(self):
    writer = StringWriter()
    self.getJavaException().printStackTrace(PrintWriter(writer))
    return "\n".join((str(super(JavaError, self)), "    Java stacktrace:", str(writer)))

class InvalidArgsError(Exception):
  pass

_orekit._set_exception_types(JavaError, InvalidArgsError)

VERSION = "11.1"
CLASSPATH = [os.path.join(__module_dir__, "orekit-11.1.jar"), os.path.join(__module_dir__, "hipparchus-core-2.0.jar"), os.path.join(__module_dir__, "hipparchus-fitting-2.0.jar"), os.path.join(__module_dir__, "hipparchus-filtering-2.0.jar"), os.path.join(__module_dir__, "hipparchus-geometry-2.0.jar"), os.path.join(__module_dir__, "hipparchus-ode-2.0.jar"), os.path.join(__module_dir__, "hipparchus-optim-2.0.jar"), os.path.join(__module_dir__, "hipparchus-stat-2.0.jar")]
CLASSPATH = os.pathsep.join(CLASSPATH)
_orekit.CLASSPATH = CLASSPATH
_orekit._set_function_self(_orekit.initVM, _orekit)

from ._orekit import *
from java.io import PrintWriter, StringWriter
