/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.hipparchus.util.FastMath;

class BigParameter
extends JacobiElliptic {
    private final JacobiElliptic algorithm;
    private final double inputScale;
    private final double outputScale;

    BigParameter(double m) {
        super(m);
        this.algorithm = JacobiEllipticBuilder.build(1.0 / m);
        this.inputScale = FastMath.sqrt(m);
        this.outputScale = 1.0 / this.inputScale;
    }

    @Override
    public CopolarN valuesN(double u) {
        CopolarN trioN = this.algorithm.valuesN(u * this.inputScale);
        return new CopolarN(this.outputScale * trioN.sn(), trioN.dn(), trioN.cn());
    }
}

