/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.io.Serializable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.AbstractRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealMatrixChangingVisitor;
import org.hipparchus.linear.RealMatrixPreservingVisitor;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class Array2DRowRealMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    private double[][] data;

    public Array2DRowRealMatrix() {
    }

    public Array2DRowRealMatrix(int rowDimension, int columnDimension) throws MathIllegalArgumentException {
        super(rowDimension, columnDimension);
        this.data = new double[rowDimension][columnDimension];
    }

    public Array2DRowRealMatrix(double[][] d) throws MathIllegalArgumentException, NullArgumentException {
        this.copyIn(d);
    }

    public Array2DRowRealMatrix(double[][] d, boolean copyArray) throws MathIllegalArgumentException, NullArgumentException {
        if (copyArray) {
            this.copyIn(d);
        } else {
            if (d == null) {
                throw new NullArgumentException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            for (int r = 1; r < nRows; ++r) {
                if (d[r].length == nCols) continue;
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, d[r].length, nCols);
            }
            this.data = d;
        }
    }

    public Array2DRowRealMatrix(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    @Override
    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws MathIllegalArgumentException {
        return new Array2DRowRealMatrix(rowDimension, columnDimension);
    }

    @Override
    public RealMatrix copy() {
        return new Array2DRowRealMatrix(this.copyOut(), false);
    }

    public Array2DRowRealMatrix add(Array2DRowRealMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            double[] dataRow = this.data[row];
            double[] mRow = m.data[row];
            double[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col] + mRow[col];
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public Array2DRowRealMatrix subtract(Array2DRowRealMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            double[] dataRow = this.data[row];
            double[] mRow = m.data[row];
            double[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col] - mRow[col];
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public Array2DRowRealMatrix multiply(Array2DRowRealMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        double[] mCol = new double[nSum];
        double[][] mData = m.data;
        for (int col = 0; col < nCols; ++col) {
            for (int mRow = 0; mRow < nSum; ++mRow) {
                mCol[mRow] = mData[mRow][col];
            }
            for (int row = 0; row < nRows; ++row) {
                double[] dataRow = this.data[row];
                double sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += dataRow[i] * mCol[i];
                }
                outData[row][col] = sum;
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public RealMatrix multiplyTransposed(Array2DRowRealMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkSameColumnDimension(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getRowDimension();
        int nSum = this.getColumnDimension();
        RealMatrix out = MatrixUtils.createRealMatrix(nRows, nCols);
        double[][] mData = m.data;
        for (int col = 0; col < nCols; ++col) {
            for (int row = 0; row < nRows; ++row) {
                double[] dataRow = this.data[row];
                double[] mRow = mData[col];
                double sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += dataRow[i] * mRow[i];
                }
                out.setEntry(row, col, sum);
            }
        }
        return out;
    }

    @Override
    public RealMatrix multiplyTransposed(RealMatrix m) {
        if (m instanceof Array2DRowRealMatrix) {
            return this.multiplyTransposed((Array2DRowRealMatrix)m);
        }
        MatrixUtils.checkSameColumnDimension(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getRowDimension();
        int nSum = this.getColumnDimension();
        RealMatrix out = MatrixUtils.createRealMatrix(nRows, nCols);
        for (int col = 0; col < nCols; ++col) {
            for (int row = 0; row < nRows; ++row) {
                double[] dataRow = this.data[row];
                double sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += dataRow[i] * m.getEntry(col, i);
                }
                out.setEntry(row, col, sum);
            }
        }
        return out;
    }

    public RealMatrix transposeMultiply(Array2DRowRealMatrix m) throws MathIllegalArgumentException {
        MatrixUtils.checkSameRowDimension(this, m);
        int nRows = this.getColumnDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getRowDimension();
        RealMatrix out = MatrixUtils.createRealMatrix(nRows, nCols);
        double[][] mData = m.data;
        for (int k = 0; k < nSum; ++k) {
            double[] dataK = this.data[k];
            double[] mK = mData[k];
            for (int row = 0; row < nRows; ++row) {
                double dataIRow = dataK[row];
                for (int col = 0; col < nCols; ++col) {
                    out.addToEntry(row, col, dataIRow * mK[col]);
                }
            }
        }
        return out;
    }

    @Override
    public RealMatrix transposeMultiply(RealMatrix m) {
        if (m instanceof Array2DRowRealMatrix) {
            return this.transposeMultiply((Array2DRowRealMatrix)m);
        }
        MatrixUtils.checkSameRowDimension(this, m);
        int nRows = this.getColumnDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getRowDimension();
        RealMatrix out = MatrixUtils.createRealMatrix(nRows, nCols);
        for (int k = 0; k < nSum; ++k) {
            double[] dataK = this.data[k];
            for (int row = 0; row < nRows; ++row) {
                double dataIRow = dataK[row];
                for (int col = 0; col < nCols; ++col) {
                    out.addToEntry(row, col, dataIRow * m.getEntry(k, col));
                }
            }
        }
        return out;
    }

    @Override
    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MathIllegalArgumentException, NullArgumentException {
        if (this.data == null) {
            if (row > 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            MathUtils.checkNotNull(subMatrix);
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            this.data = new double[subMatrix.length][nCols];
            for (int i = 0; i < this.data.length; ++i) {
                if (subMatrix[i].length != nCols) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, subMatrix[i].length, nCols);
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public double getEntry(int row, int column) throws MathIllegalArgumentException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        return this.data[row][column];
    }

    @Override
    public void setEntry(int row, int column, double value) throws MathIllegalArgumentException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        this.data[row][column] = value;
    }

    @Override
    public void addToEntry(int row, int column, double increment) throws MathIllegalArgumentException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        double[] dArray = this.data[row];
        int n = column;
        dArray[n] = dArray[n] + increment;
    }

    @Override
    public void multiplyEntry(int row, int column, double factor) throws MathIllegalArgumentException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        double[] dArray = this.data[row];
        int n = column;
        dArray[n] = dArray[n] * factor;
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public double[] operate(double[] v) throws MathIllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, v.length, nCols);
        }
        double[] out = new double[nRows];
        for (int row = 0; row < nRows; ++row) {
            double[] dataRow = this.data[row];
            double sum = 0.0;
            for (int i = 0; i < nCols; ++i) {
                sum += dataRow[i] * v[i];
            }
            out[row] = sum;
        }
        return out;
    }

    @Override
    public double[] preMultiply(double[] v) throws MathIllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, v.length, nRows);
        }
        double[] out = new double[nCols];
        for (int col = 0; col < nCols; ++col) {
            double sum = 0.0;
            for (int i = 0; i < nRows; ++i) {
                sum += this.data[i][col] * v[i];
            }
            out[col] = sum;
        }
        return out;
    }

    @Override
    public RealMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        int rowCount = endRow - startRow + 1;
        int columnCount = endColumn - startColumn + 1;
        double[][] outData = new double[rowCount][columnCount];
        for (int i = 0; i < rowCount; ++i) {
            System.arraycopy(this.data[startRow + i], startColumn, outData[i], 0, columnCount);
        }
        Array2DRowRealMatrix subMatrix = new Array2DRowRealMatrix();
        subMatrix.data = outData;
        return subMatrix;
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            double[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            double[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                double[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                double[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(double[][] in) throws MathIllegalArgumentException, NullArgumentException {
        this.setSubMatrix(in, 0, 0);
    }

    @Override
    public double[] getRow(int row) throws MathIllegalArgumentException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        double[] out = new double[nCols];
        System.arraycopy(this.data[row], 0, out, 0, nCols);
        return out;
    }

    @Override
    public void setRow(int row, double[] array) throws MathIllegalArgumentException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, 1, array.length, 1, nCols);
        }
        System.arraycopy(array, 0, this.data[row], 0, nCols);
    }

    public RealMatrix kroneckerProduct(RealMatrix b) {
        int m = this.getRowDimension();
        int n = this.getColumnDimension();
        int p = b.getRowDimension();
        int q = b.getColumnDimension();
        RealMatrix kroneckerProduct = MatrixUtils.createRealMatrix(m * p, n * q);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                kroneckerProduct.setSubMatrix(b.scalarMultiply(this.getEntry(i, j)).getData(), i * p, j * q);
            }
        }
        return kroneckerProduct;
    }

    public RealMatrix stack() {
        int m = this.getRowDimension();
        int n = this.getColumnDimension();
        RealMatrix stacked = MatrixUtils.createRealMatrix(m * n, 1);
        for (int i = 0; i < m; ++i) {
            stacked.setSubMatrix(this.getColumnMatrix(i).getData(), i * n, 0);
        }
        return stacked;
    }

    public RealMatrix unstackSquare() {
        int m = this.getRowDimension();
        int n = this.getColumnDimension();
        int s = (int)FastMath.round(FastMath.sqrt(m));
        if (n != 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, n, 1);
        }
        if (s * s != m) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, s, (double)m / (double)s);
        }
        RealMatrix unstacked = MatrixUtils.createRealMatrix(s, s);
        for (int i = 0; i < s; ++i) {
            unstacked.setColumnMatrix(i, this.getSubMatrix(i * s, i * s + s - 1, 0, 0));
        }
        return unstacked;
    }
}

