/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import java.util.function.DoubleFunction;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.integration.UnivariateIntegrator;
import org.hipparchus.complex.Complex;

public class ComplexUnivariateIntegrator {
    private UnivariateIntegrator integrator;

    public ComplexUnivariateIntegrator(UnivariateIntegrator integrator) {
        this.integrator = integrator;
    }

    public Complex integrate(int maxEval, CalculusFieldUnivariateFunction<Complex> f, Complex start, Complex end) {
        Complex rate = end.subtract(start);
        DoubleFunction<Complex> mapped = t -> f.value(start.add(rate.multiply(t)));
        double real = this.integrator.integrate(maxEval, (double t) -> ((Complex)mapped.apply(t)).getRealPart(), 0.0, 1.0);
        double imaginary = this.integrator.integrate(maxEval, (double t) -> ((Complex)mapped.apply(t)).getImaginaryPart(), 0.0, 1.0);
        return new Complex(real, imaginary).multiply(rate);
    }

    public Complex integrate(int maxEval, CalculusFieldUnivariateFunction<Complex> f, Complex start, Complex ... path) {
        Complex sum = Complex.ZERO;
        Complex previous = start;
        for (Complex current : path) {
            sum = sum.add(this.integrate(maxEval, f, previous, current));
            previous = current;
        }
        return sum;
    }
}

