/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.integration.FieldUnivariateIntegrator;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.MathUtils;

public abstract class BaseAbstractFieldUnivariateIntegrator<T extends CalculusFieldElement<T>>
implements FieldUnivariateIntegrator<T> {
    public static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-15;
    public static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-6;
    public static final int DEFAULT_MIN_ITERATIONS_COUNT = 3;
    public static final int DEFAULT_MAX_ITERATIONS_COUNT = Integer.MAX_VALUE;
    protected final Incrementor iterations;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private final int minimalIterationCount;
    private Incrementor evaluations;
    private final Field<T> field;
    private CalculusFieldUnivariateFunction<T> function;
    private T min;
    private T max;

    protected BaseAbstractFieldUnivariateIntegrator(Field<T> field, double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        this.relativeAccuracy = relativeAccuracy;
        this.absoluteAccuracy = absoluteAccuracy;
        if (minimalIterationCount <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, minimalIterationCount, 0);
        }
        if (maximalIterationCount <= minimalIterationCount) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, maximalIterationCount, minimalIterationCount);
        }
        this.minimalIterationCount = minimalIterationCount;
        this.iterations = new Incrementor(maximalIterationCount);
        this.evaluations = new Incrementor();
        this.field = field;
    }

    protected BaseAbstractFieldUnivariateIntegrator(Field<T> field, double relativeAccuracy, double absoluteAccuracy) {
        this(field, relativeAccuracy, absoluteAccuracy, 3, Integer.MAX_VALUE);
    }

    protected BaseAbstractFieldUnivariateIntegrator(Field<T> field, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        this(field, 1.0E-6, 1.0E-15, minimalIterationCount, maximalIterationCount);
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    @Override
    public int getMaximalIterationCount() {
        return this.iterations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public int getIterations() {
        return this.iterations.getCount();
    }

    protected T getMin() {
        return this.min;
    }

    protected T getMax() {
        return this.max;
    }

    protected T computeObjectiveValue(T point) throws MathIllegalStateException {
        this.evaluations.increment();
        return this.function.value(point);
    }

    protected void setup(int maxEval, CalculusFieldUnivariateFunction<T> f, T lower, T upper) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(f);
        UnivariateSolverUtils.verifyInterval(lower.getReal(), upper.getReal());
        this.min = lower;
        this.max = upper;
        this.function = f;
        this.evaluations = this.evaluations.withMaximalCount(maxEval);
        this.iterations.reset();
    }

    @Override
    public T integrate(int maxEval, CalculusFieldUnivariateFunction<T> f, T lower, T upper) throws MathIllegalArgumentException, MathIllegalStateException, NullArgumentException {
        this.setup(maxEval, f, lower, upper);
        return this.doIntegrate();
    }

    protected abstract T doIntegrate() throws MathIllegalStateException;
}

