/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;

public class LegendrePolynomials {
    private double[][] pCoef;

    public LegendrePolynomials(int degree, int order, double t) {
        this.pCoef = new double[degree + 1][order + 1];
        double t2 = t * t;
        for (int n = 0; n <= degree; ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                int r = (n - m) / 2;
                double sum = 0.0;
                for (int k = 0; k <= r; ++k) {
                    double term = FastMath.pow((double)-1.0, (int)k) * CombinatoricsUtils.factorialDouble((int)(2 * n - 2 * k)) / (CombinatoricsUtils.factorialDouble((int)k) * CombinatoricsUtils.factorialDouble((int)(n - k)) * CombinatoricsUtils.factorialDouble((int)(n - m - 2 * k))) * FastMath.pow((double)t, (int)(n - m - 2 * k));
                    sum += term;
                }
                this.pCoef[n][m] = FastMath.pow((double)2.0, (int)(-n)) * FastMath.pow((double)(1.0 - t2), (double)(0.5 * (double)m)) * sum;
            }
        }
    }

    public double getPnm(int n, int m) {
        return this.pCoef[n][m];
    }
}

