/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.OffsetModel;
import org.orekit.time.UTCTAIOffsetsLoader;
import org.orekit.time.UtcTaiOffsetLoader;

public class AGILeapSecondFilesLoader
extends AbstractSelfFeedingLoader
implements UTCTAIOffsetsLoader {
    public static final String DEFAULT_SUPPORTED_NAMES = "^LeapSecond\\.dat$";

    @DefaultDataContext
    public AGILeapSecondFilesLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager());
    }

    public AGILeapSecondFilesLoader(String supportedNames, DataProvidersManager manager) {
        super(supportedNames, manager);
    }

    @Override
    public List<OffsetModel> loadOffsets() {
        UtcTaiOffsetLoader parser = new UtcTaiOffsetLoader(new Parser());
        this.feed(parser);
        return parser.getOffsets();
    }

    public static class Parser
    implements UTCTAIOffsetsLoader.Parser {
        private static final String BLANKS = "\\p{Blank}*";
        private static final String STORAGE_START = "(";
        private static final String STORAGE_END = ")";
        private static final String ALTERNATIVE = "|";
        private static final String LINE_START_REGEXP = "^\\p{Blank}*";
        private static final String LINE_END_REGEXP = "\\p{Blank}*$";
        private static final String INTEGER_REGEXP = "[-+]?\\p{Digit}+";
        private static final String REAL_REGEXP = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
        private static final String STORED_INTEGER_FIELD = "\\p{Blank}*([-+]?\\p{Digit}+)";
        private static final String STORED_REAL_FIELD = "\\p{Blank}*([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)";
        private Pattern dataPattern;

        public Parser() {
            StringBuilder builder = new StringBuilder("\\p{Blank}*(");
            for (Month month : Month.values()) {
                builder.append(month.getUpperCaseAbbreviation());
                builder.append(ALTERNATIVE);
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append(STORAGE_END);
            String monthField = builder.toString();
            this.dataPattern = Pattern.compile("^\\p{Blank}*\\p{Blank}*([-+]?\\p{Digit}+)" + monthField + STORED_INTEGER_FIELD + BLANKS + STORED_REAL_FIELD + BLANKS + STORED_REAL_FIELD + BLANKS + STORED_REAL_FIELD + BLANKS + STORED_REAL_FIELD + LINE_END_REGEXP);
        }

        @Override
        public List<OffsetModel> parse(InputStream input, String name) throws IOException {
            ArrayList<OffsetModel> offsets = new ArrayList<OffsetModel>();
            int lineNumber = 0;
            DateComponents lastDate = null;
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                line = reader.readLine();
                while (line != null) {
                    ++lineNumber;
                    Matcher matcher = this.dataPattern.matcher(line);
                    if (matcher.matches()) {
                        DateComponents dc2;
                        DateComponents dc1 = new DateComponents(Integer.parseInt(matcher.group(1)), Month.parseMonth(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                        if (!dc1.equals(dc2 = new DateComponents(DateComponents.JULIAN_EPOCH, (int)FastMath.ceil((double)Double.parseDouble(matcher.group(4)))))) {
                            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, dc1.getYear(), dc1.getMonth(), dc1.getDay(), dc2.getMJD());
                        }
                        if (lastDate != null && dc1.compareTo(lastDate) <= 0) {
                            throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICAL_DATES_IN_FILE, name, lineNumber);
                        }
                        lastDate = dc1;
                        double offset = Double.parseDouble(matcher.group(5));
                        double mjdRef = Double.parseDouble(matcher.group(6));
                        double slope = Double.parseDouble(matcher.group(7));
                        offsets.add(new OffsetModel(dc1, (int)FastMath.rint((double)mjdRef), offset, slope));
                    }
                    line = reader.readLine();
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            if (offsets.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NO_ENTRIES_IN_IERS_UTC_TAI_HISTORY_FILE, name);
            }
            return offsets;
        }
    }
}

