/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldCjSjCoefficient;

public class FieldGHmsjPolynomials<T extends CalculusFieldElement<T>> {
    private final FieldCjSjCoefficient<T> cjsjKH;
    private final FieldCjSjCoefficient<T> cjsjAB;
    private int I;
    private final T zero;

    public FieldGHmsjPolynomials(T k, T h, T alpha, T beta, int retroFactor, Field<T> field) {
        this.zero = (CalculusFieldElement)field.getZero();
        this.cjsjKH = new FieldCjSjCoefficient<T>(k, h, field);
        this.cjsjAB = new FieldCjSjCoefficient<T>(alpha, beta, field);
        this.I = retroFactor;
    }

    public T getGmsj(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object gms = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            gms = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getCj(mMis))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.sgn(s - j))).multiply(this.I)));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            gms = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getCj(sMim))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(this.sgn(s - j))).multiply(this.sgn(s - m))));
        }
        return gms;
    }

    public T getHmsj(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object hms = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            hms = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getCj(mMis))).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            hms = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(-this.sgn(s - m))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getCj(sMim))).multiply(this.sgn(s - j))));
        }
        return hms;
    }

    public T getdGmsdk(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdk = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdk = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getCj(mMis))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdk = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getCj(sMim))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(this.sgn(s - m))).multiply(this.sgn(s - j))));
        }
        return dGmsdk;
    }

    public T getdGmsdh(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdh = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdh = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getCj(mMis))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdh = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getCj(sMim))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(this.sgn(s - m))).multiply(this.sgn(s - j))));
        }
        return dGmsdh;
    }

    public T getdGmsdAlpha(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdAl = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdAl = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDk(mMis))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDk(mMis))).multiply(this.I)).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdAl = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDk(sMim))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDk(sMim))).multiply(this.sgn(s - j))).multiply(this.sgn(s - m))));
        }
        return dGmsdAl;
    }

    public T getdGmsdBeta(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dGmsdBe = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dGmsdBe = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDh(mMis))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDh(mMis))).multiply(this.I)).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dGmsdBe = (CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDcjDh(sMim))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDsjDh(sMim))).multiply(this.sgn(s - j))).multiply(this.sgn(s - m))));
        }
        return dGmsdBe;
    }

    public T getdHmsdk(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdk = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdk = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getCj(mMis))).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdk = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDk(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(-this.sgn(s - m))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDk(sMj).multiply(this.cjsjAB.getCj(sMim))).multiply(this.sgn(s - j))));
        }
        return dHmsdk;
    }

    public T getdHmsdh(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdh = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdh = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getSj(mMis))).multiply(this.I)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getCj(mMis))).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdh = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDcjDh(sMj).multiply(this.cjsjAB.getSj(sMim))).multiply(-this.sgn(s - m))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getDsjDh(sMj).multiply(this.cjsjAB.getCj(sMim))).multiply(this.sgn(s - j))));
        }
        return dHmsdh;
    }

    public T getdHmsdAlpha(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdAl = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdAl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDk(mMis))).multiply(this.I)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDk(mMis))).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdAl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDk(sMim))).multiply(-this.sgn(s - m))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDk(sMim))).multiply(this.sgn(s - j))));
        }
        return dHmsdAl;
    }

    public T getdHmsdBeta(int m, int s, int j) {
        int sMj = FastMath.abs((int)(s - j));
        Object dHmsdBe = this.zero;
        if (FastMath.abs((int)s) <= m) {
            int mMis = m - this.I * s;
            dHmsdBe = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDh(mMis))).multiply(this.I)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDh(mMis))).multiply(this.sgn(s - j))));
        } else {
            int sMim = FastMath.abs((int)(s - this.I * m));
            dHmsdBe = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getCj(sMj).multiply(this.cjsjAB.getDsjDh(sMim))).multiply(-this.sgn(s - m))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cjsjKH.getSj(sMj).multiply(this.cjsjAB.getDcjDh(sMim))).multiply(this.sgn(s - j))));
        }
        return dHmsdBe;
    }

    private int sgn(int i) {
        return i < 0 ? -1 : 1;
    }
}

