/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.TreeMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class CoefficientsFactory {
    private static TreeMap<NSKey, Double> VNS = new TreeMap();
    private static int LAST_VNS_ORDER = 2;

    private CoefficientsFactory() {
    }

    public static double[][] computeQns(double gamma, int nMax, int sMax) {
        int snDim;
        int sDim = FastMath.min((int)(sMax + 1), (int)nMax) + 1;
        int rows = nMax + 1;
        double[][] Qns = new double[rows][];
        for (int i = 0; i <= nMax; ++i) {
            snDim = FastMath.min((int)(i + 1), (int)sDim);
            Qns[i] = new double[snDim];
        }
        Qns[0][0] = 1.0;
        for (int n = 1; n <= nMax; ++n) {
            snDim = FastMath.min((int)(n + 1), (int)sDim);
            for (int s = 0; s < snDim; ++s) {
                if (n == s) {
                    Qns[n][s] = (2.0 * (double)s - 1.0) * Qns[s - 1][s - 1];
                    continue;
                }
                if (n == s + 1) {
                    Qns[n][s] = (2.0 * (double)s + 1.0) * gamma * Qns[s][s];
                    continue;
                }
                Qns[n][s] = (2.0 * (double)n - 1.0) * gamma * Qns[n - 1][s] - ((double)(n + s) - 1.0) * Qns[n - 2][s];
                double[] dArray = Qns[n];
                int n2 = s;
                dArray[n2] = dArray[n2] / (double)(n - s);
            }
        }
        return Qns;
    }

    public static <T extends CalculusFieldElement<T>> T[][] computeQns(T gamma, int nMax, int sMax) {
        int snDim;
        int sDim = FastMath.min((int)(sMax + 1), (int)nMax) + 1;
        int rows = nMax + 1;
        CalculusFieldElement[][] Qns = (CalculusFieldElement[][])MathArrays.buildArray((Field)gamma.getField(), (int)rows, (int)(FastMath.min((int)(nMax + 1), (int)sDim) - 1));
        for (int i = 0; i <= nMax; ++i) {
            snDim = FastMath.min((int)(i + 1), (int)sDim);
            Qns[i] = (CalculusFieldElement[])MathArrays.buildArray((Field)gamma.getField(), (int)snDim);
        }
        Qns[0][0] = (CalculusFieldElement)((CalculusFieldElement)gamma.subtract(gamma)).add(1.0);
        for (int n = 1; n <= nMax; ++n) {
            snDim = FastMath.min((int)(n + 1), (int)sDim);
            for (int s = 0; s < snDim; ++s) {
                if (n == s) {
                    Qns[n][s] = (CalculusFieldElement)Qns[s - 1][s - 1].multiply(2.0 * (double)s - 1.0);
                    continue;
                }
                if (n == s + 1) {
                    Qns[n][s] = (CalculusFieldElement)((CalculusFieldElement)Qns[s][s].multiply(gamma)).multiply(2.0 * (double)s + 1.0);
                    continue;
                }
                Qns[n][s] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)Qns[n - 1][s].multiply(gamma)).multiply(2.0 * (double)n - 1.0)).subtract((FieldElement)((CalculusFieldElement)Qns[n - 2][s].multiply((double)(n + s) - 1.0)));
                Qns[n][s] = (CalculusFieldElement)Qns[n][s].divide((double)(n - s));
            }
        }
        return Qns;
    }

    public static double[][] computeGsHs(double k, double h, double alpha, double beta, int order) {
        double hamkb = h * alpha - k * beta;
        double kaphb = k * alpha + h * beta;
        double[][] GsHs = new double[2][order + 1];
        GsHs[0][0] = 1.0;
        GsHs[1][0] = 0.0;
        for (int s = 1; s <= order; ++s) {
            GsHs[0][s] = kaphb * GsHs[0][s - 1] - hamkb * GsHs[1][s - 1];
            GsHs[1][s] = hamkb * GsHs[0][s - 1] + kaphb * GsHs[1][s - 1];
        }
        return GsHs;
    }

    public static <T extends CalculusFieldElement<T>> T[][] computeGsHs(T k, T h, T alpha, T beta, int order, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement hamkb = (CalculusFieldElement)((CalculusFieldElement)h.multiply(alpha)).subtract((FieldElement)((CalculusFieldElement)k.multiply(beta)));
        CalculusFieldElement kaphb = (CalculusFieldElement)((CalculusFieldElement)k.multiply(alpha)).add((FieldElement)((CalculusFieldElement)h.multiply(beta)));
        CalculusFieldElement[][] GsHs = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)2, (int)(order + 1));
        GsHs[0][0] = (CalculusFieldElement)zero.add(1.0);
        GsHs[1][0] = zero;
        for (int s = 1; s <= order; ++s) {
            GsHs[0][s] = (CalculusFieldElement)((CalculusFieldElement)kaphb.multiply((FieldElement)GsHs[0][s - 1])).subtract((FieldElement)((CalculusFieldElement)hamkb.multiply((FieldElement)GsHs[1][s - 1])));
            GsHs[1][s] = (CalculusFieldElement)((CalculusFieldElement)hamkb.multiply((FieldElement)GsHs[0][s - 1])).add((FieldElement)((CalculusFieldElement)kaphb.multiply((FieldElement)GsHs[1][s - 1])));
        }
        return GsHs;
    }

    public static TreeMap<NSKey, Double> computeVns(int order) {
        if (order > LAST_VNS_ORDER) {
            int min;
            for (int n = min = LAST_VNS_ORDER - 2 < 0 ? 0 : LAST_VNS_ORDER - 2; n < order; ++n) {
                for (int s = 0; s < n + 1; ++s) {
                    if ((n - s) % 2 != 0) {
                        VNS.put(new NSKey(n, s), 0.0);
                        continue;
                    }
                    if (n == s && s + 1 < order) {
                        VNS.put(new NSKey(s + 1, s + 1), VNS.get(new NSKey(s, s)) / ((double)(2 * s) + 2.0));
                    }
                    if (n + 2 >= order) continue;
                    VNS.put(new NSKey(n + 2, s), VNS.get(new NSKey(n, s)) * ((double)(-n + s) - 1.0) / ((double)(n + s) + 2.0));
                }
            }
            LAST_VNS_ORDER = order;
        }
        return VNS;
    }

    public static double getVmns(int m, int n, int s) {
        if (m > n) {
            throw new OrekitException((Localizable)OrekitMessages.DSST_VMNS_COEFFICIENT_ERROR_MS, m, n);
        }
        double fns = CombinatoricsUtils.factorialDouble((int)(n + FastMath.abs((int)s)));
        double fnm = CombinatoricsUtils.factorialDouble((int)(n - m));
        double result = 0.0;
        if ((n - s) % 2 == 0) {
            if (n + 1 > LAST_VNS_ORDER) {
                CoefficientsFactory.computeVns(n + 1);
            }
            if (s >= 0) {
                result = fns * VNS.get(new NSKey(n, s)) / fnm;
            } else {
                int mops = s % 2 == 0 ? 1 : -1;
                result = (double)mops * fns * VNS.get(new NSKey(n, -s)) / fnm;
            }
        }
        return result;
    }

    static {
        VNS.put(new NSKey(0, 0), 1.0);
        VNS.put(new NSKey(1, 0), 0.0);
        VNS.put(new NSKey(1, 1), 0.5);
    }

    public static class NSKey
    implements Comparable<NSKey> {
        private final int n;
        private final int s;

        public NSKey(int n, int s) {
            this.n = n;
            this.s = s;
        }

        public int getN() {
            return this.n;
        }

        public int getS() {
            return this.s;
        }

        @Override
        public int compareTo(NSKey key) {
            int result = 1;
            if (this.n == key.n) {
                if (this.s < key.s) {
                    result = -1;
                } else if (this.s == key.s) {
                    result = 0;
                }
            } else if (this.n < key.n) {
                result = -1;
            }
            return result;
        }

        public boolean equals(Object key) {
            if (key == this) {
                return true;
            }
            if (key instanceof NSKey) {
                return this.n == ((NSKey)key).n && this.s == ((NSKey)key).s;
            }
            return false;
        }

        public int hashCode() {
            return 0x998493A6 ^ this.n << 8 ^ this.s;
        }
    }
}

