/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldDSSTTesseralContext<T extends CalculusFieldElement<T>>
extends FieldForceModelContext<T> {
    private static final int I = 1;
    private T A;
    private T chi;
    private T chi2;
    private T theta;
    private T ax2oA;
    private T ooAB;
    private T BoA;
    private T BoABpo;
    private T Co2AB;
    private T moa;
    private T roa;
    private T e2;
    private T n;
    private T period;
    private T ratio;

    FieldDSSTTesseralContext(FieldAuxiliaryElements<T> auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, int maxFrequencyShortPeriodics, double bodyPeriod, T[] parameters) {
        super(auxiliaryElements);
        Field<T> field = auxiliaryElements.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        T mu = parameters[0];
        CalculusFieldElement absA = FastMath.abs(auxiliaryElements.getSma());
        this.n = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.divide((FieldElement)absA))).divide((FieldElement)absA);
        T a = auxiliaryElements.getSma();
        this.period = a.getReal() < 0.0 ? (CalculusFieldElement)zero.add(Double.POSITIVE_INFINITY) : (CalculusFieldElement)((CalculusFieldElement)a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a.getPi()).multiply(2.0)))).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a.divide(mu)).sqrt()));
        this.A = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.multiply(auxiliaryElements.getSma())));
        this.e2 = (CalculusFieldElement)auxiliaryElements.getEcc().multiply(auxiliaryElements.getEcc());
        FieldTransform<T> t = centralBodyFrame.getTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
        FieldVector3D<T> xB = t.transformVector(FieldVector3D.getPlusI(field));
        FieldVector3D<T> yB = t.transformVector(FieldVector3D.getPlusJ(field));
        this.theta = FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getVectorF().dotProduct(yB).negate()).add((FieldElement)((CalculusFieldElement)auxiliaryElements.getVectorG().dotProduct(xB).multiply(1)))), (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getVectorF().dotProduct(xB).add((FieldElement)((CalculusFieldElement)auxiliaryElements.getVectorG().dotProduct(yB).multiply(1)))));
        this.ax2oA = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getSma().divide(this.A)).multiply(2.0);
        this.BoA = (CalculusFieldElement)auxiliaryElements.getB().divide(this.A);
        this.ooAB = (CalculusFieldElement)((CalculusFieldElement)this.A.multiply(auxiliaryElements.getB())).reciprocal();
        this.Co2AB = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0);
        this.BoABpo = (CalculusFieldElement)this.BoA.divide((FieldElement)((CalculusFieldElement)auxiliaryElements.getB().add(1.0)));
        this.moa = (CalculusFieldElement)mu.divide(auxiliaryElements.getSma());
        this.roa = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getSma().divide(provider.getAe())).reciprocal();
        this.chi = (CalculusFieldElement)auxiliaryElements.getB().reciprocal();
        this.chi2 = (CalculusFieldElement)this.chi.multiply(this.chi);
        this.ratio = (CalculusFieldElement)this.period.divide(bodyPeriod);
    }

    public T getE2() {
        return this.e2;
    }

    public T getTheta() {
        return this.theta;
    }

    public T getAx2oA() {
        return this.ax2oA;
    }

    public T getChi() {
        return this.chi;
    }

    public T getChi2() {
        return this.chi2;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getCo2AB() {
        return this.Co2AB;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getMoa() {
        return this.moa;
    }

    public T getRoa() {
        return this.roa;
    }

    public T getOrbitPeriod() {
        return this.period;
    }

    public T getMeanMotion() {
        return this.n;
    }

    public T getRatio() {
        return this.ratio;
    }
}

