/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface DSSTForceModel {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.init(initialState.toSpacecraftState(), target.toAbsoluteDate());
    }

    public List<ShortPeriodTerms> initializeShortPeriodTerms(AuxiliaryElements var1, PropagationType var2, double[] var3);

    public <T extends CalculusFieldElement<T>> List<FieldShortPeriodTerms<T>> initializeShortPeriodTerms(FieldAuxiliaryElements<T> var1, PropagationType var2, T[] var3);

    default public double[] getParameters() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue();
        }
        return parameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(drivers.get(i).getValue());
        }
        return parameters;
    }

    public double[] getMeanElementRate(SpacecraftState var1, AuxiliaryElements var2, double[] var3);

    public <T extends CalculusFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> var1, FieldAuxiliaryElements<T> var2, T[] var3);

    public EventDetector[] getEventsDetectors();

    public <T extends CalculusFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> var1);

    public void registerAttitudeProvider(AttitudeProvider var1);

    public void updateShortPeriodTerms(double[] var1, SpacecraftState ... var2);

    public <T extends CalculusFieldElement<T>> void updateShortPeriodTerms(T[] var1, FieldSpacecraftState<T> ... var2);

    public List<ParameterDriver> getParametersDrivers();
}

