/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical.cr3bp;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.cr3bp.CR3BPForceModel;
import org.orekit.time.AbsoluteDate;

public class STMEquations
implements AdditionalDerivativesProvider,
AdditionalEquations {
    private static final int DIM = 6;
    private final CR3BPSystem syst;
    private final String name;
    private final double[][] jacobian = new double[6][6];

    public STMEquations(CR3BPSystem syst) {
        this.syst = syst;
        this.name = "stmEquations";
        for (int j = 0; j < this.jacobian.length; ++j) {
            Arrays.fill(this.jacobian[j], 0.0);
        }
        this.jacobian[0][3] = 1.0;
        this.jacobian[1][4] = 1.0;
        this.jacobian[2][5] = 1.0;
        this.jacobian[3][4] = 2.0;
        this.jacobian[4][3] = -2.0;
    }

    public SpacecraftState setInitialPhi(SpacecraftState s) {
        int stateDimension = 36;
        double[] phi = new double[36];
        for (int i = 0; i < 36; i += 7) {
            phi[i] = 1.0;
        }
        return s.addAdditionalState(this.name, phi);
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        AdditionalDerivativesProvider.super.init(initialState, target);
    }

    @Override
    public double[] computeDerivatives(SpacecraftState s, double[] pDot) {
        System.arraycopy(this.derivatives(s), 0, pDot, 0, pDot.length);
        return null;
    }

    @Override
    public double[] derivatives(SpacecraftState s) {
        double[] phi = s.getAdditionalState(this.getName());
        double[] dPhi = new double[phi.length];
        DerivativeStructure potential = new CR3BPForceModel(this.syst).getPotential(s);
        double[] dU = potential.getAllDerivatives();
        int idXX = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{2, 0, 0});
        int idXY = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{1, 1, 0});
        int idXZ = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{1, 0, 1});
        int idYY = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 2, 0});
        int idYZ = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 1, 1});
        int idZZ = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 0, 2});
        this.jacobian[3][0] = dU[idXX];
        this.jacobian[4][1] = dU[idYY];
        this.jacobian[5][2] = dU[idZZ];
        this.jacobian[3][1] = dU[idXY];
        this.jacobian[4][0] = this.jacobian[3][1];
        this.jacobian[3][2] = dU[idXZ];
        this.jacobian[5][0] = this.jacobian[3][2];
        this.jacobian[4][2] = dU[idYZ];
        this.jacobian[5][1] = this.jacobian[4][2];
        for (int k = 0; k < 6; ++k) {
            for (int l = 0; l < 6; ++l) {
                for (int i = 0; i < 6; ++i) {
                    dPhi[6 * k + l] = dPhi[6 * k + l] + this.jacobian[k][i] * phi[6 * i + l];
                }
            }
        }
        return dPhi;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDimension() {
        return 36;
    }

    public RealMatrix getStateTransitionMatrix(SpacecraftState s) {
        double[][] phi2dA = new double[6][6];
        double[] stm = s.getAdditionalState(this.getName());
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                phi2dA[i][j] = stm[6 * i + j];
            }
        }
        return new Array2DRowRealMatrix(phi2dA, false);
    }
}

