/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.analytical.gnss.GLONASSAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.data.GLONASSOrbitalElements;
import org.orekit.utils.IERSConventions;

public class GLONASSAnalyticalPropagatorBuilder {
    private final GLONASSOrbitalElements orbit;
    private AttitudeProvider attitudeProvider;
    private double mass;
    private Frame eci;
    private Frame ecef;
    private DataContext dataContext;

    @DefaultDataContext
    public GLONASSAnalyticalPropagatorBuilder(GLONASSOrbitalElements glonassOrbElt) {
        this(glonassOrbElt, DataContext.getDefault());
    }

    public GLONASSAnalyticalPropagatorBuilder(GLONASSOrbitalElements glonassOrbElt, DataContext dataContext) {
        this.orbit = glonassOrbElt;
        this.dataContext = dataContext;
        this.mass = 1000.0;
        Frames frames = dataContext.getFrames();
        this.eci = frames.getEME2000();
        this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
        this.attitudeProvider = InertialProvider.of(this.eci);
    }

    public GLONASSAnalyticalPropagatorBuilder attitudeProvider(AttitudeProvider userProvider) {
        this.attitudeProvider = userProvider;
        return this;
    }

    public GLONASSAnalyticalPropagatorBuilder mass(double userMass) {
        this.mass = userMass;
        return this;
    }

    public GLONASSAnalyticalPropagatorBuilder eci(Frame inertial) {
        this.eci = inertial;
        return this;
    }

    public GLONASSAnalyticalPropagatorBuilder ecef(Frame bodyFixed) {
        this.ecef = bodyFixed;
        return this;
    }

    public GLONASSAnalyticalPropagatorBuilder dataContext(DataContext context) {
        this.dataContext = context;
        return this;
    }

    public GLONASSAnalyticalPropagator build() {
        return new GLONASSAnalyticalPropagator(this.orbit, this.eci, this.ecef, this.attitudeProvider, this.mass, this.dataContext);
    }
}

