/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import org.hipparchus.linear.RealMatrix;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.KeplerianHarvester;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.TimeSpanMap;

public class KeplerianPropagator
extends AbstractAnalyticalPropagator {
    private TimeSpanMap<SpacecraftState> states;

    public KeplerianPropagator(Orbit initialOrbit) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, double mu) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv) {
        this(initialOrbit, attitudeProv, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu) {
        this(initialOrbit, attitudeProv, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu, double mass) {
        super(attitudeProv);
        SpacecraftState initial = this.fixState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass, mu, null, null);
        this.states = new TimeSpanMap<SpacecraftState>(initial);
        super.resetInitialState(initial);
    }

    private SpacecraftState fixState(Orbit orbit, Attitude attitude, double mass, double mu, DoubleArrayDictionary additionalStates, DoubleArrayDictionary additionalStatesDerivatives) {
        OrbitType type = orbit.getType();
        double[] stateVector = new double[6];
        type.mapOrbitToArray(orbit, PositionAngle.TRUE, stateVector, null);
        Orbit fixedOrbit = type.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, orbit.getDate(), mu, orbit.getFrame());
        SpacecraftState fixedState = new SpacecraftState(fixedOrbit, attitude, mass);
        if (additionalStates != null) {
            for (DoubleArrayDictionary.Entry entry : additionalStates.getData()) {
                fixedState = fixedState.addAdditionalState(entry.getKey(), entry.getValue());
            }
        }
        if (additionalStatesDerivatives != null) {
            for (DoubleArrayDictionary.Entry entry : additionalStatesDerivatives.getData()) {
                fixedState = fixedState.addAdditionalStateDerivative(entry.getKey(), entry.getValue());
            }
        }
        return fixedState;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        SpacecraftState formerInitial = this.getInitialState();
        double mu = formerInitial == null ? state.getMu() : formerInitial.getMu();
        SpacecraftState fixedState = this.fixState(state.getOrbit(), state.getAttitude(), state.getMass(), mu, state.getAdditionalStatesValues(), state.getAdditionalStatesDerivatives());
        this.states = new TimeSpanMap<SpacecraftState>(fixedState);
        super.resetInitialState(fixedState);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        if (forward) {
            this.states.addValidAfter(state, state.getDate(), false);
        } else {
            this.states.addValidBefore(state, state.getDate(), false);
        }
        this.stateChanged(state);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        Orbit orbit = this.states.get(date).getOrbit();
        while (!date.equals((orbit = orbit.shiftedBy(date.durationFrom(orbit.getDate()))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.states.get(date).getMass();
    }

    @Override
    protected AbstractMatricesHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        return new KeplerianHarvester(this, stmName, initialStm, initialJacobianColumns);
    }
}

