/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldCircularOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEcksteinHechlerPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private FieldEHModel<T> initialModel;
    private transient FieldTimeSpanMap<FieldEHModel<T>, T> models;
    private double referenceRadius;
    private T mu;
    private double[] ck0;

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitude, (CalculusFieldElement)mass, provider.getAe(), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(provider.getMu()), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), harmonics.getUnnormalizedCnm(6, 0));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double c60) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, InertialProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getDate().getField().getZero()).add(1000.0), referenceRadius, (CalculusFieldElement)mu, c20, c30, c40, c50, c60);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, T mass, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mass, referenceRadius, mu, c20, c30, c40, c50, c60);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, attitudeProv, (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double c60) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitudeProv, (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getDate().getField().getZero()).add(1000.0), referenceRadius, (CalculusFieldElement)mu, c20, c30, c40, c50, c60);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()));
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double c60) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, c60, PropagationType.OSCULATING);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), initialType);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), initialType);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, PropagationType initialType) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitude, (CalculusFieldElement)mass, provider.getAe(), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(provider.getMu()), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), harmonics.getUnnormalizedCnm(6, 0), initialType);
    }

    public FieldEcksteinHechlerPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double c60, PropagationType initialType) {
        super(mass.getField(), attitudeProv);
        try {
            this.referenceRadius = referenceRadius;
            this.mu = mu;
            this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50, c60};
            this.resetInitialState(new FieldSpacecraftState<T>(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass), initialType);
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe);
        }
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        this.resetInitialState(state, PropagationType.OSCULATING);
    }

    public void resetInitialState(FieldSpacecraftState<T> state, PropagationType stateType) {
        super.resetInitialState(state);
        FieldCircularOrbit circular = (FieldCircularOrbit)OrbitType.CIRCULAR.convertType(state.getOrbit());
        this.initialModel = stateType == PropagationType.MEAN ? new FieldEHModel<T>(circular, state.getMass(), this.referenceRadius, this.mu, this.ck0) : this.computeMeanParameters(circular, state.getMass());
        this.models = new FieldTimeSpanMap(this.initialModel, state.getA().getField());
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        FieldEHModel<T> newModel = this.computeMeanParameters((FieldCircularOrbit)OrbitType.CIRCULAR.convertType(state.getOrbit()), state.getMass());
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate());
        } else {
            this.models.addValidBefore(newModel, state.getDate());
        }
        this.stateChanged(state);
    }

    private FieldEHModel<T> computeMeanParameters(FieldCircularOrbit<T> osculating, T mass) {
        if (osculating.getA().getReal() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        Field field = mass.getField();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldEHModel<Object> current = new FieldEHModel(osculating, mass, this.referenceRadius, this.mu, this.ck0);
        CalculusFieldElement epsilon = (CalculusFieldElement)one.multiply(1.0E-13);
        CalculusFieldElement thresholdA = (CalculusFieldElement)epsilon.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((FieldEHModel)current).mean.getA().abs()).add(1.0)));
        CalculusFieldElement thresholdE = (CalculusFieldElement)epsilon.multiply((FieldElement)((CalculusFieldElement)((FieldEHModel)current).mean.getE().add(1.0)));
        CalculusFieldElement thresholdAngles = (CalculusFieldElement)epsilon.multiply((FieldElement)((CalculusFieldElement)one.getPi()));
        int i = 0;
        while (i++ < 100) {
            FieldUnivariateDerivative2<T>[] parameters = current.propagateParameters(((FieldEHModel)current).mean.getDate());
            CalculusFieldElement deltaA = (CalculusFieldElement)osculating.getA().subtract((FieldElement)parameters[0].getValue());
            CalculusFieldElement deltaEx = (CalculusFieldElement)osculating.getCircularEx().subtract((FieldElement)parameters[1].getValue());
            CalculusFieldElement deltaEy = (CalculusFieldElement)osculating.getCircularEy().subtract((FieldElement)parameters[2].getValue());
            CalculusFieldElement deltaI = (CalculusFieldElement)osculating.getI().subtract((FieldElement)parameters[3].getValue());
            CalculusFieldElement deltaRAAN = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getRightAscensionOfAscendingNode().subtract((FieldElement)parameters[4].getValue())), (CalculusFieldElement)zero);
            CalculusFieldElement deltaAlphaM = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getAlphaM().subtract((FieldElement)parameters[5].getValue())), (CalculusFieldElement)zero);
            current = new FieldEHModel<CalculusFieldElement>(new FieldCircularOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldEHModel)current).mean.getA().add((FieldElement)deltaA), (CalculusFieldElement)((FieldEHModel)current).mean.getCircularEx().add((FieldElement)deltaEx), (CalculusFieldElement)((FieldEHModel)current).mean.getCircularEy().add((FieldElement)deltaEy), (CalculusFieldElement)((FieldEHModel)current).mean.getI().add((FieldElement)deltaI), (CalculusFieldElement)((FieldEHModel)current).mean.getRightAscensionOfAscendingNode().add((FieldElement)deltaRAAN), (CalculusFieldElement)((FieldEHModel)current).mean.getAlphaM().add((FieldElement)deltaAlphaM), PositionAngle.MEAN, ((FieldEHModel)current).mean.getFrame(), ((FieldEHModel)current).mean.getDate(), (CalculusFieldElement)this.mu), (CalculusFieldElement)mass, this.referenceRadius, (CalculusFieldElement)this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA.getReal()) < thresholdA.getReal()) || !(FastMath.abs((double)deltaEx.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaEy.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaI.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaRAAN.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaAlphaM.getReal()) < thresholdAngles.getReal())) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECKSTEIN_HECHLER_MEAN_PARAMETERS, i);
    }

    @Override
    public FieldCartesianOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        FieldEHModel<T> current = this.models.get(date);
        return new FieldCartesianOrbit<T>(this.toCartesian(date, current.propagateParameters(date)), ((FieldEHModel)current).mean.getFrame(), this.mu);
    }

    private TimeStampedFieldPVCoordinates<T> toCartesian(FieldAbsoluteDate<T> date, FieldUnivariateDerivative2<T>[] parameters) {
        FieldUnivariateDerivative2 cosOmega = parameters[4].cos();
        FieldUnivariateDerivative2 sinOmega = parameters[4].sin();
        FieldUnivariateDerivative2 cosI = parameters[3].cos();
        FieldUnivariateDerivative2 sinI = parameters[3].sin();
        FieldUnivariateDerivative2<T> alphaE = this.meanToEccentric(parameters[5], parameters[1], parameters[2]);
        FieldUnivariateDerivative2 cosAE = alphaE.cos();
        FieldUnivariateDerivative2 sinAE = alphaE.sin();
        FieldUnivariateDerivative2 ex2 = parameters[1].multiply(parameters[1]);
        FieldUnivariateDerivative2 ey2 = parameters[2].multiply(parameters[2]);
        FieldUnivariateDerivative2 exy = parameters[1].multiply(parameters[2]);
        FieldUnivariateDerivative2 q = ex2.add(ey2).subtract(1.0).negate().sqrt();
        FieldUnivariateDerivative2 beta = q.add(1.0).reciprocal();
        FieldUnivariateDerivative2 bx2 = beta.multiply(ex2);
        FieldUnivariateDerivative2 by2 = beta.multiply(ey2);
        FieldUnivariateDerivative2 bxy = beta.multiply(exy);
        FieldUnivariateDerivative2 u = bxy.multiply(sinAE).subtract(parameters[1].add(by2.subtract(1.0).multiply(cosAE)));
        FieldUnivariateDerivative2 v = bxy.multiply(cosAE).subtract(parameters[2].add(bx2.subtract(1.0).multiply(sinAE)));
        FieldUnivariateDerivative2 x = parameters[0].multiply(u);
        FieldUnivariateDerivative2 y = parameters[0].multiply(v);
        FieldVector3D p = new FieldVector3D((CalculusFieldElement)x.multiply(cosOmega).subtract(y.multiply(cosI.multiply(sinOmega))), (CalculusFieldElement)x.multiply(sinOmega).add(y.multiply(cosI.multiply(cosOmega))), (CalculusFieldElement)y.multiply(sinI));
        FieldVector3D p0 = new FieldVector3D(((FieldUnivariateDerivative2)p.getX()).getValue(), ((FieldUnivariateDerivative2)p.getY()).getValue(), ((FieldUnivariateDerivative2)p.getZ()).getValue());
        FieldVector3D p1 = new FieldVector3D(((FieldUnivariateDerivative2)p.getX()).getFirstDerivative(), ((FieldUnivariateDerivative2)p.getY()).getFirstDerivative(), ((FieldUnivariateDerivative2)p.getZ()).getFirstDerivative());
        FieldVector3D p2 = new FieldVector3D(((FieldUnivariateDerivative2)p.getX()).getSecondDerivative(), ((FieldUnivariateDerivative2)p.getY()).getSecondDerivative(), ((FieldUnivariateDerivative2)p.getZ()).getSecondDerivative());
        return new TimeStampedFieldPVCoordinates<T>(date, p0, p1, p2);
    }

    private FieldUnivariateDerivative2<T> meanToEccentric(FieldUnivariateDerivative2<T> alphaM, FieldUnivariateDerivative2<T> ex, FieldUnivariateDerivative2<T> ey) {
        FieldUnivariateDerivative2 alphaE = alphaM;
        FieldUnivariateDerivative2 shift = alphaM.getField().getZero();
        FieldUnivariateDerivative2 alphaEMalphaM = alphaM.getField().getZero();
        FieldUnivariateDerivative2 cosAlphaE = alphaE.cos();
        FieldUnivariateDerivative2 sinAlphaE = alphaE.sin();
        int iter = 0;
        do {
            FieldUnivariateDerivative2 f2 = ex.multiply(sinAlphaE).subtract(ey.multiply(cosAlphaE));
            FieldUnivariateDerivative2 f1 = alphaM.getField().getOne().subtract(ex.multiply(cosAlphaE)).subtract(ey.multiply(sinAlphaE));
            FieldUnivariateDerivative2 f0 = alphaEMalphaM.subtract(f2);
            FieldUnivariateDerivative2 f12 = f1.multiply(2);
            shift = f0.multiply(f12).divide(f1.multiply(f12).subtract(f0.multiply(f2)));
            alphaEMalphaM = alphaEMalphaM.subtract(shift);
            alphaE = alphaM.add(alphaEMalphaM);
            cosAlphaE = alphaE.cos();
            sinAlphaE = alphaE.sin();
        } while (++iter < 50 && FastMath.abs((double)shift.getValue().getReal()) > 1.0E-12);
        return alphaE;
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return (T)((FieldEHModel)this.models.get(date)).mass;
    }

    @Override
    protected List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private static class FieldEHModel<T extends CalculusFieldElement<T>> {
        private final FieldCircularOrbit<T> mean;
        private final T mass;
        private final T xnotDot;
        private final T rdpom;
        private final T rdpomp;
        private final T eps1;
        private final T eps2;
        private final T xim;
        private final T ommD;
        private final T rdl;
        private final T aMD;
        private final T kh;
        private final T kl;
        private final T ax1;
        private final T ay1;
        private final T as1;
        private final T ac2;
        private final T axy3;
        private final T as3;
        private final T ac4;
        private final T as5;
        private final T ac6;
        private final T ex1;
        private final T exx2;
        private final T exy2;
        private final T ex3;
        private final T ex4;
        private final T ey1;
        private final T eyx2;
        private final T eyy2;
        private final T ey3;
        private final T ey4;
        private final T rx1;
        private final T ry1;
        private final T r2;
        private final T r3;
        private final T rl;
        private final T iy1;
        private final T ix1;
        private final T i2;
        private final T i3;
        private final T ih;
        private final T lx1;
        private final T ly1;
        private final T l2;
        private final T l3;
        private final T ll;

        FieldEHModel(FieldCircularOrbit<T> mean, T mass, double referenceRadius, T mu, double[] ck0) {
            this.mean = mean;
            this.mass = mass;
            CalculusFieldElement zero = (CalculusFieldElement)mass.getField().getZero();
            CalculusFieldElement one = (CalculusFieldElement)mass.getField().getOne();
            CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)zero.add(referenceRadius)).divide(mean.getA());
            CalculusFieldElement ql = (CalculusFieldElement)q.multiply((FieldElement)q);
            CalculusFieldElement g2 = (CalculusFieldElement)ql.multiply(ck0[2]);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement g3 = (CalculusFieldElement)ql.multiply(ck0[3]);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement g4 = (CalculusFieldElement)ql.multiply(ck0[4]);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement g5 = (CalculusFieldElement)ql.multiply(ck0[5]);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement g6 = (CalculusFieldElement)ql.multiply(ck0[6]);
            FieldSinCos sc = FastMath.sinCos(mean.getI());
            CalculusFieldElement cosI1 = (CalculusFieldElement)sc.cos();
            CalculusFieldElement sinI1 = (CalculusFieldElement)sc.sin();
            CalculusFieldElement sinI2 = (CalculusFieldElement)sinI1.multiply((FieldElement)sinI1);
            CalculusFieldElement sinI4 = (CalculusFieldElement)sinI2.multiply((FieldElement)sinI2);
            CalculusFieldElement sinI6 = (CalculusFieldElement)sinI2.multiply((FieldElement)sinI4);
            if (sinI2.getReal() < 1.0E-10) {
                throw new OrekitException((Localizable)OrekitMessages.ALMOST_EQUATORIAL_ORBIT, FastMath.toDegrees((double)mean.getI().getReal()));
            }
            if (FastMath.abs((double)(sinI2.getReal() - 0.8)) < 0.001) {
                throw new OrekitException((Localizable)OrekitMessages.ALMOST_CRITICALLY_INCLINED_ORBIT, FastMath.toDegrees((double)mean.getI().getReal()));
            }
            if (mean.getE().getReal() > 0.1) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, mean.getE());
            }
            this.xnotDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(mean.getA())).sqrt()).divide(mean.getA());
            this.rdpom = (CalculusFieldElement)((CalculusFieldElement)g2.multiply(-0.75)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-5.0)).add(4.0)));
            this.rdpomp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g4.multiply(7.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-3.875)).add(1.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(3.0625)))))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g6.multiply(13.125)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)sinI2.multiply(8.0)))).add((FieldElement)((CalculusFieldElement)sinI4.multiply(16.125)))).subtract((FieldElement)((CalculusFieldElement)sinI6.multiply(9.28125)))))));
            q = (CalculusFieldElement)((CalculusFieldElement)zero.add(3.0)).divide((FieldElement)((CalculusFieldElement)this.rdpom.multiply(32.0)));
            this.eps1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply((FieldElement)g4)).multiply((FieldElement)sinI2)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-35.0)).add(30.0)))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(175.0)).multiply((FieldElement)g6)).multiply((FieldElement)sinI2)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-3.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(2.0625)))).add(1.0)))));
            q = (CalculusFieldElement)((CalculusFieldElement)sinI1.multiply(3.0)).divide((FieldElement)((CalculusFieldElement)this.rdpom.multiply(8.0)));
            this.eps2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply((FieldElement)g3)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-5.0)).add(4.0)))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply((FieldElement)g5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-35.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(26.25)))).add(10.0)))));
            this.xim = mean.getI();
            this.ommD = (CalculusFieldElement)cosI1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g2.multiply(1.5)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g2.multiply(2.25)).multiply((FieldElement)g2)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-3.1666666666666665)).add(2.5)))))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g4.multiply(0.9375)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(7.0)).subtract(4.0)))))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g6.multiply(3.28125)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-9.0)).add(2.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(8.25)))))))));
            this.rdl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g2.multiply(-1.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-4.0)).add(3.0)))).add(1.0);
            this.aMD = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.rdl.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g2.multiply(2.25)).multiply((FieldElement)((CalculusFieldElement)g2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-21.916666666666668)).add(9.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(14.208333333333334)))))))))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g4.multiply(0.9375)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-31.0)).add(8.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(24.5)))))))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g6.multiply(3.28125)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(25.0)).add(-3.3333333333333335)).subtract((FieldElement)((CalculusFieldElement)sinI4.multiply(48.75)))).add((FieldElement)((CalculusFieldElement)sinI6.multiply(27.5)))))));
            CalculusFieldElement qq = (CalculusFieldElement)((CalculusFieldElement)g2.divide(this.rdl)).multiply(-1.5);
            CalculusFieldElement qA = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g2.multiply(0.75)).multiply((FieldElement)g2)).multiply((FieldElement)sinI2);
            CalculusFieldElement qB = (CalculusFieldElement)((CalculusFieldElement)g4.multiply(0.25)).multiply((FieldElement)sinI2);
            CalculusFieldElement qC = (CalculusFieldElement)((CalculusFieldElement)g6.multiply(6.5625)).multiply((FieldElement)sinI2);
            CalculusFieldElement qD = (CalculusFieldElement)((CalculusFieldElement)g3.multiply(-0.75)).multiply((FieldElement)sinI1);
            CalculusFieldElement qE = (CalculusFieldElement)((CalculusFieldElement)g5.multiply(3.75)).multiply((FieldElement)sinI1);
            this.kh = (CalculusFieldElement)((CalculusFieldElement)zero.add(0.375)).divide(this.rdpom);
            this.kl = (CalculusFieldElement)this.kh.divide((FieldElement)sinI1);
            this.ax1 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-3.5)).add(2.0)));
            this.ay1 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-2.5)).add(2.0)));
            this.as1 = (CalculusFieldElement)((CalculusFieldElement)qD.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-5.0)).add(4.0)))).add((FieldElement)((CalculusFieldElement)qE.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI4.multiply(2.625)).add((FieldElement)((CalculusFieldElement)sinI2.multiply(-3.5)))).add(1.0)))));
            this.ac2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qq.multiply((FieldElement)sinI2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)qA.multiply(7.0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-3.0)).add(2.0)))))).add((FieldElement)((CalculusFieldElement)qB.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-17.5)).add(15.0)))))).add((FieldElement)((CalculusFieldElement)qC.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(3.0)).subtract(1.0)).subtract((FieldElement)((CalculusFieldElement)sinI4.multiply(2.0625)))))));
            this.axy3 = (CalculusFieldElement)((CalculusFieldElement)qq.multiply(3.5)).multiply((FieldElement)sinI2);
            this.as3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qD.multiply(1.6666666666666667)).multiply((FieldElement)sinI2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qE.multiply(1.1666666666666667)).multiply((FieldElement)sinI2)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-1.125)).add(1.0)))));
            this.ac4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qA.multiply((FieldElement)sinI2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)qB.multiply(4.375)).multiply((FieldElement)sinI2)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)qC.multiply(0.75)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI4.multiply(1.1)).subtract((FieldElement)sinI2)))));
            this.as5 = (CalculusFieldElement)((CalculusFieldElement)qE.multiply(0.2625)).multiply((FieldElement)sinI4);
            this.ac6 = (CalculusFieldElement)((CalculusFieldElement)qC.multiply(-0.1375)).multiply((FieldElement)sinI4);
            this.ex1 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-1.25)).add(1.0)));
            this.exx2 = (CalculusFieldElement)((CalculusFieldElement)qq.multiply(0.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-5.0)).add(3.0)));
            this.exy2 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-1.5)).add(2.0)));
            this.ex3 = (CalculusFieldElement)((CalculusFieldElement)qq.multiply(0.5833333333333334)).multiply((FieldElement)sinI2);
            this.ex4 = (CalculusFieldElement)((CalculusFieldElement)qq.multiply(2.125)).multiply((FieldElement)sinI2);
            this.ey1 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-1.75)).add(1.0)));
            this.eyx2 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-3.0)).add(1.0)));
            this.eyy2 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(2.0)).subtract(1.5)));
            this.ey3 = (CalculusFieldElement)((CalculusFieldElement)qq.multiply(0.5833333333333334)).multiply((FieldElement)sinI2);
            this.ey4 = (CalculusFieldElement)((CalculusFieldElement)qq.multiply(2.125)).multiply((FieldElement)sinI2);
            q = (CalculusFieldElement)((CalculusFieldElement)cosI1.multiply((FieldElement)qq)).negate();
            this.rx1 = (CalculusFieldElement)q.multiply(3.5);
            this.ry1 = (CalculusFieldElement)q.multiply(-2.5);
            this.r2 = (CalculusFieldElement)q.multiply(-0.5);
            this.r3 = (CalculusFieldElement)q.multiply(1.1666666666666667);
            this.rl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g3.multiply((FieldElement)cosI1)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-15.0)).add(4.0)))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g5.multiply(2.5)).multiply((FieldElement)cosI1)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-42.0)).add(4.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(52.5)))))));
            q = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qq.multiply(0.5)).multiply((FieldElement)sinI1)).multiply((FieldElement)cosI1);
            this.iy1 = q;
            this.ix1 = (CalculusFieldElement)q.negate();
            this.i2 = q;
            this.i3 = (CalculusFieldElement)q.multiply(2.3333333333333335);
            this.ih = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g3.negate()).multiply((FieldElement)cosI1)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-5.0)).add(4.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g5.multiply(2.5)).multiply((FieldElement)cosI1)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-14.0)).add(4.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(10.5)))))));
            this.lx1 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-9.625)).add(7.0)));
            this.ly1 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(6.875)).subtract(7.5)));
            this.l2 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(1.25)).subtract(0.5)));
            this.l3 = (CalculusFieldElement)qq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(3.2083333333333335)).subtract(1.1666666666666667)));
            this.ll = (CalculusFieldElement)((CalculusFieldElement)g3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(53.0)).subtract(4.0)).add((FieldElement)((CalculusFieldElement)sinI4.multiply(-57.5)))))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g5.multiply(2.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI2.multiply(-96.0)).add(4.0)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI4.multiply(269.5)).subtract((FieldElement)((CalculusFieldElement)sinI6.multiply(183.75)))))))));
        }

        public FieldUnivariateDerivative2<T>[] propagateParameters(FieldAbsoluteDate<T> date) {
            Field field = date.durationFrom(this.mean.getDate()).getField();
            CalculusFieldElement one = (CalculusFieldElement)field.getOne();
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            FieldUnivariateDerivative2 dt = new FieldUnivariateDerivative2(date.durationFrom(this.mean.getDate()), one, zero);
            FieldUnivariateDerivative2 xnot = dt.multiply(this.xnotDot);
            FieldUnivariateDerivative2 x = xnot.multiply((CalculusFieldElement)this.rdpom.add(this.rdpomp));
            FieldUnivariateDerivative2 cx = x.cos();
            FieldUnivariateDerivative2 sx = x.sin();
            FieldUnivariateDerivative2 exm = cx.multiply(this.mean.getCircularEx()).add(sx.multiply((CalculusFieldElement)this.eps2.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)one.subtract(this.eps1)).multiply(this.mean.getCircularEy())))));
            FieldUnivariateDerivative2 eym = sx.multiply((CalculusFieldElement)((CalculusFieldElement)this.eps1.add(1.0)).multiply(this.mean.getCircularEx())).add(cx.multiply((CalculusFieldElement)this.mean.getCircularEy().subtract(this.eps2))).add(this.eps2);
            FieldUnivariateDerivative2 omm = new FieldUnivariateDerivative2(MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)this.mean.getRightAscensionOfAscendingNode().add((FieldElement)((CalculusFieldElement)this.ommD.multiply((FieldElement)xnot.getValue())))), (CalculusFieldElement)((CalculusFieldElement)one.getPi())), (CalculusFieldElement)this.ommD.multiply(this.xnotDot), zero);
            FieldUnivariateDerivative2 xlm = new FieldUnivariateDerivative2(MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)this.mean.getAlphaM().add((FieldElement)((CalculusFieldElement)this.aMD.multiply((FieldElement)xnot.getValue())))), (CalculusFieldElement)((CalculusFieldElement)one.getPi())), (CalculusFieldElement)this.aMD.multiply(this.xnotDot), zero);
            FieldUnivariateDerivative2 cl1 = xlm.cos();
            FieldUnivariateDerivative2 sl1 = xlm.sin();
            FieldUnivariateDerivative2 cl2 = cl1.multiply(cl1).subtract(sl1.multiply(sl1));
            FieldUnivariateDerivative2 sl2 = cl1.multiply(sl1).add(sl1.multiply(cl1));
            FieldUnivariateDerivative2 cl3 = cl2.multiply(cl1).subtract(sl2.multiply(sl1));
            FieldUnivariateDerivative2 sl3 = cl2.multiply(sl1).add(sl2.multiply(cl1));
            FieldUnivariateDerivative2 cl4 = cl3.multiply(cl1).subtract(sl3.multiply(sl1));
            FieldUnivariateDerivative2 sl4 = cl3.multiply(sl1).add(sl3.multiply(cl1));
            FieldUnivariateDerivative2 cl5 = cl4.multiply(cl1).subtract(sl4.multiply(sl1));
            FieldUnivariateDerivative2 sl5 = cl4.multiply(sl1).add(sl4.multiply(cl1));
            FieldUnivariateDerivative2 cl6 = cl5.multiply(cl1).subtract(sl5.multiply(sl1));
            FieldUnivariateDerivative2 qh = eym.subtract(this.eps2).multiply(this.kh);
            FieldUnivariateDerivative2 ql = exm.multiply(this.kl);
            FieldUnivariateDerivative2 exmCl1 = exm.multiply(cl1);
            FieldUnivariateDerivative2 exmSl1 = exm.multiply(sl1);
            FieldUnivariateDerivative2 eymCl1 = eym.multiply(cl1);
            FieldUnivariateDerivative2 eymSl1 = eym.multiply(sl1);
            FieldUnivariateDerivative2 exmCl2 = exm.multiply(cl2);
            FieldUnivariateDerivative2 exmSl2 = exm.multiply(sl2);
            FieldUnivariateDerivative2 eymCl2 = eym.multiply(cl2);
            FieldUnivariateDerivative2 eymSl2 = eym.multiply(sl2);
            FieldUnivariateDerivative2 exmCl3 = exm.multiply(cl3);
            FieldUnivariateDerivative2 exmSl3 = exm.multiply(sl3);
            FieldUnivariateDerivative2 eymCl3 = eym.multiply(cl3);
            FieldUnivariateDerivative2 eymSl3 = eym.multiply(sl3);
            FieldUnivariateDerivative2 exmCl4 = exm.multiply(cl4);
            FieldUnivariateDerivative2 exmSl4 = exm.multiply(sl4);
            FieldUnivariateDerivative2 eymCl4 = eym.multiply(cl4);
            FieldUnivariateDerivative2 eymSl4 = eym.multiply(sl4);
            FieldUnivariateDerivative2 rda = exmCl1.multiply(this.ax1).add(eymSl1.multiply(this.ay1)).add(sl1.multiply(this.as1)).add(cl2.multiply(this.ac2)).add(exmCl3.add(eymSl3).multiply(this.axy3)).add(sl3.multiply(this.as3)).add(cl4.multiply(this.ac4)).add(sl5.multiply(this.as5)).add(cl6.multiply(this.ac6));
            FieldUnivariateDerivative2 rdex = cl1.multiply(this.ex1).add(exmCl2.multiply(this.exx2)).add(eymSl2.multiply(this.exy2)).add(cl3.multiply(this.ex3)).add(exmCl4.add(eymSl4).multiply(this.ex4));
            FieldUnivariateDerivative2 rdey = sl1.multiply(this.ey1).add(exmSl2.multiply(this.eyx2)).add(eymCl2.multiply(this.eyy2)).add(sl3.multiply(this.ey3)).add(exmSl4.subtract(eymCl4).multiply(this.ey4));
            FieldUnivariateDerivative2 rdom = exmSl1.multiply(this.rx1).add(eymCl1.multiply(this.ry1)).add(sl2.multiply(this.r2)).add(eymCl3.subtract(exmSl3).multiply(this.r3)).add(ql.multiply(this.rl));
            FieldUnivariateDerivative2 rdxi = eymSl1.multiply(this.iy1).add(exmCl1.multiply(this.ix1)).add(cl2.multiply(this.i2)).add(exmCl3.add(eymSl3).multiply(this.i3)).add(qh.multiply(this.ih));
            FieldUnivariateDerivative2 rdxl = exmSl1.multiply(this.lx1).add(eymCl1.multiply(this.ly1)).add(sl2.multiply(this.l2)).add(exmSl3.subtract(eymCl3).multiply(this.l3)).add(ql.multiply(this.ll));
            FieldUnivariateDerivative2[] FTD = (FieldUnivariateDerivative2[])MathArrays.buildArray((Field)rdxl.getField(), (int)6);
            FTD[0] = rda.add(1.0).multiply(this.mean.getA());
            FTD[1] = rdex.add(exm);
            FTD[2] = rdey.add(eym);
            FTD[3] = rdxi.add(this.xim);
            FTD[4] = rdom.add(omm);
            FTD[5] = rdxl.add(xlm);
            return FTD;
        }
    }
}

