/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.Collection;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.linear.RealMatrix;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.EphemerisGenerator;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.StepHandlerMultiplexer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.PVCoordinatesProvider;

public interface Propagator
extends PVCoordinatesProvider {
    public static final double DEFAULT_MASS = 1000.0;

    public static AttitudeProvider getDefaultLaw(Frames frames) {
        return new InertialProvider(Rotation.IDENTITY, frames.getEME2000());
    }

    public StepHandlerMultiplexer getMultiplexer();

    default public void clearStepHandlers() {
        this.getMultiplexer().clear();
    }

    default public void setStepHandler(double h, OrekitFixedStepHandler handler) {
        this.getMultiplexer().clear();
        this.getMultiplexer().add(h, handler);
    }

    default public void setStepHandler(OrekitStepHandler handler) {
        this.getMultiplexer().clear();
        this.getMultiplexer().add(handler);
    }

    public EphemerisGenerator getEphemerisGenerator();

    public SpacecraftState getInitialState();

    public void resetInitialState(SpacecraftState var1);

    public void addAdditionalStateProvider(AdditionalStateProvider var1);

    public List<AdditionalStateProvider> getAdditionalStateProviders();

    public boolean isAdditionalStateManaged(String var1);

    public String[] getManagedAdditionalStates();

    public <T extends EventDetector> void addEventDetector(T var1);

    public Collection<EventDetector> getEventsDetectors();

    public void clearEventsDetectors();

    public AttitudeProvider getAttitudeProvider();

    public void setAttitudeProvider(AttitudeProvider var1);

    public Frame getFrame();

    default public MatricesHarvester setupMatricesComputation(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        throw new UnsupportedOperationException();
    }

    public SpacecraftState propagate(AbsoluteDate var1);

    public SpacecraftState propagate(AbsoluteDate var1, AbsoluteDate var2);
}

