/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.RealMatrix;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.StepHandlerMultiplexer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractPropagator
implements Propagator {
    private StepHandlerMultiplexer multiplexer = new StepHandlerMultiplexer();
    private AbsoluteDate startDate;
    private AttitudeProvider attitudeProvider;
    private final List<AdditionalStateProvider> additionalStateProviders = new ArrayList<AdditionalStateProvider>();
    private final Map<String, TimeSpanMap<double[]>> unmanagedStates = new HashMap<String, TimeSpanMap<double[]>>();
    private SpacecraftState initialState;
    private AbstractMatricesHarvester harvester = null;

    protected AbstractPropagator() {
    }

    protected void setStartDate(AbsoluteDate startDate) {
        this.startDate = startDate;
    }

    protected AbsoluteDate getStartDate() {
        return this.startDate;
    }

    @Override
    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attitudeProvider = attitudeProvider;
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.initialState;
    }

    @Override
    public Frame getFrame() {
        return this.initialState.getFrame();
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        this.initialState = state;
        this.setStartDate(state.getDate());
    }

    @Override
    public StepHandlerMultiplexer getMultiplexer() {
        return this.multiplexer;
    }

    @Override
    public void addAdditionalStateProvider(AdditionalStateProvider provider) {
        if (this.isAdditionalStateManaged(provider.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, provider.getName());
        }
        this.additionalStateProviders.add(provider);
    }

    @Override
    public List<AdditionalStateProvider> getAdditionalStateProviders() {
        return Collections.unmodifiableList(this.additionalStateProviders);
    }

    @Override
    public MatricesHarvester setupMatricesComputation(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        if (stmName == null) {
            throw new OrekitException((Localizable)OrekitMessages.NULL_ARGUMENT, "stmName");
        }
        this.harvester = this.createHarvester(stmName, initialStm, initialJacobianColumns);
        return this.harvester;
    }

    protected AbstractMatricesHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        throw new UnsupportedOperationException();
    }

    protected AbstractMatricesHarvester getHarvester() {
        return this.harvester;
    }

    protected SpacecraftState updateUnmanagedStates(SpacecraftState original) {
        SpacecraftState updated = original;
        for (Map.Entry<String, TimeSpanMap<double[]>> entry : this.unmanagedStates.entrySet()) {
            updated = updated.addAdditionalState(entry.getKey(), entry.getValue().get(original.getDate()));
        }
        return updated;
    }

    protected SpacecraftState updateAdditionalStates(SpacecraftState original) {
        SpacecraftState updated = this.updateUnmanagedStates(original);
        LinkedList<AdditionalStateProvider> pending = new LinkedList<AdditionalStateProvider>(this.getAdditionalStateProviders());
        int yieldCount = 0;
        while (!pending.isEmpty()) {
            AdditionalStateProvider provider = (AdditionalStateProvider)pending.remove();
            if (provider.yield(updated)) {
                pending.add(provider);
                if (++yieldCount < pending.size()) continue;
                break;
            }
            updated = updated.addAdditionalState(provider.getName(), provider.getAdditionalState(updated));
            yieldCount = 0;
        }
        return updated;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        for (AdditionalStateProvider provider : this.additionalStateProviders) {
            if (!provider.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] managed = new String[this.additionalStateProviders.size()];
        for (int i = 0; i < managed.length; ++i) {
            managed[i] = this.additionalStateProviders.get(i).getName();
        }
        return managed;
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate target) {
        if (this.startDate == null) {
            this.startDate = this.getInitialState().getDate();
        }
        return this.propagate(this.startDate, target);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    protected void initializePropagation() {
        this.unmanagedStates.clear();
        if (this.initialState != null) {
            for (DoubleArrayDictionary.Entry initial : this.initialState.getAdditionalStatesValues().getData()) {
                if (this.isAdditionalStateManaged(initial.getKey())) continue;
                this.unmanagedStates.put(initial.getKey(), new TimeSpanMap<double[]>(initial.getValue()));
            }
        }
    }

    protected void stateChanged(SpacecraftState state) {
        AbsoluteDate date = state.getDate();
        boolean forward = date.durationFrom(this.getStartDate()) >= 0.0;
        for (DoubleArrayDictionary.Entry changed : state.getAdditionalStatesValues().getData()) {
            TimeSpanMap<double[]> tsm = this.unmanagedStates.get(changed.getKey());
            if (tsm == null) continue;
            if (forward) {
                tsm.addValidAfter(changed.getValue(), date, false);
                continue;
            }
            tsm.addValidBefore(changed.getValue(), date, false);
        }
    }
}

