/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public class NiellMappingFunctionModel
implements MappingFunction {
    private static final double[] VALUES_FOR_AH_AVERAGE = new double[]{0.0012769934, 0.001268323, 0.0012465397, 0.0012196049, 0.0012045996};
    private static final double[] VALUES_FOR_BH_AVERAGE = new double[]{0.0029153695, 0.0029152299, 0.0029288445, 0.0029022565, 0.0029024912};
    private static final double[] VALUES_FOR_CH_AVERAGE = new double[]{0.062610505, 0.062837393, 0.063721774, 0.063824265, 0.064258455};
    private static final double[] VALUES_FOR_AH_AMPLITUDE = new double[]{0.0, 1.2709626E-5, 2.6523662E-5, 3.4000452E-5, 4.1202191E-5};
    private static final double[] VALUES_FOR_BH_AMPLITUDE = new double[]{0.0, 2.1414979E-5, 3.0160779E-5, 7.2562722E-5, 1.1723375E-4};
    private static final double[] VALUES_FOR_CH_AMPLITUDE = new double[]{0.0, 9.01284E-5, 4.3497037E-5, 8.4795348E-4, 0.0017037206};
    private static final double[] VALUES_FOR_AW = new double[]{5.8021897E-4, 5.6794847E-4, 5.8118019E-4, 5.9727542E-4, 6.1641693E-4};
    private static final double[] VALUES_FOR_BW = new double[]{0.0014275268, 0.0015138625, 0.0014572752, 0.0015007428, 0.0017599082};
    private static final double[] VALUES_FOR_CW = new double[]{0.043472961, 0.04672951, 0.043908931, 0.044626982, 0.054736038};
    private static final double[] LATITUDE_VALUES = new double[]{FastMath.toRadians((double)15.0), FastMath.toRadians((double)30.0), FastMath.toRadians((double)45.0), FastMath.toRadians((double)60.0), FastMath.toRadians((double)75.0)};
    private final UnivariateFunction ahAverageFunction;
    private final UnivariateFunction bhAverageFunction;
    private final UnivariateFunction chAverageFunction;
    private final UnivariateFunction ahAmplitudeFunction;
    private final UnivariateFunction bhAmplitudeFunction;
    private final UnivariateFunction chAmplitudeFunction;
    private final UnivariateFunction awFunction;
    private final UnivariateFunction bwFunction;
    private final UnivariateFunction cwFunction;
    private final TimeScale utc;

    @DefaultDataContext
    public NiellMappingFunctionModel() {
        this(DataContext.getDefault().getTimeScales().getUTC());
    }

    public NiellMappingFunctionModel(TimeScale utc) {
        this.utc = utc;
        this.ahAverageFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_AH_AVERAGE);
        this.bhAverageFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_BH_AVERAGE);
        this.chAverageFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_CH_AVERAGE);
        this.ahAmplitudeFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_AH_AMPLITUDE);
        this.bhAmplitudeFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_BH_AMPLITUDE);
        this.chAmplitudeFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_CH_AMPLITUDE);
        this.awFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_AW);
        this.bwFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_BW);
        this.cwFunction = new LinearInterpolator().interpolate(LATITUDE_VALUES, VALUES_FOR_CW);
    }

    @Override
    public double[] mappingFactors(double elevation, GeodeticPoint point, AbsoluteDate date) {
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        double t0 = 28.0;
        if (point.getLatitude() < 0.0) {
            t0 += 183.0;
        }
        double coef = Math.PI * 2 * (((double)dofyear - t0) / 365.25);
        double cosCoef = FastMath.cos((double)coef);
        double absLatidude = FastMath.abs((double)point.getLatitude());
        absLatidude = FastMath.max((double)FastMath.toRadians((double)15.0), (double)absLatidude);
        absLatidude = FastMath.min((double)FastMath.toRadians((double)75.0), (double)absLatidude);
        double ah = this.ahAverageFunction.value(absLatidude) - this.ahAmplitudeFunction.value(absLatidude) * cosCoef;
        double bh = this.bhAverageFunction.value(absLatidude) - this.bhAmplitudeFunction.value(absLatidude) * cosCoef;
        double ch = this.chAverageFunction.value(absLatidude) - this.chAmplitudeFunction.value(absLatidude) * cosCoef;
        double[] function = new double[]{TroposphericModelUtils.mappingFunction(ah, bh, ch, elevation), TroposphericModelUtils.mappingFunction(this.awFunction.value(absLatidude), this.bwFunction.value(absLatidude), this.cwFunction.value(absLatidude), elevation)};
        double correction = TroposphericModelUtils.computeHeightCorrection(elevation, point.getAltitude());
        function[0] = function[0] + correction;
        return function;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(T elevation, FieldGeodeticPoint<T> point, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        DateTimeComponents dtc = date.getComponents(this.utc);
        int dofyear = dtc.getDate().getDayOfYear();
        double t0 = 28.0;
        if (point.getLatitude().getReal() < 0.0) {
            t0 += 183.0;
        }
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(2.0)).multiply(((double)dofyear - t0) / 365.25);
        CalculusFieldElement cosCoef = FastMath.cos((CalculusFieldElement)coef);
        double absLatidude = FastMath.abs((double)point.getLatitude().getReal());
        absLatidude = FastMath.max((double)FastMath.toRadians((double)15.0), (double)absLatidude);
        absLatidude = FastMath.min((double)FastMath.toRadians((double)75.0), (double)absLatidude);
        CalculusFieldElement ah = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosCoef.multiply(this.ahAmplitudeFunction.value(absLatidude))).negate()).add(this.ahAverageFunction.value(absLatidude));
        CalculusFieldElement bh = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosCoef.multiply(this.bhAmplitudeFunction.value(absLatidude))).negate()).add(this.bhAverageFunction.value(absLatidude));
        CalculusFieldElement ch = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosCoef.multiply(this.chAmplitudeFunction.value(absLatidude))).negate()).add(this.chAverageFunction.value(absLatidude));
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        function[0] = TroposphericModelUtils.mappingFunction(ah, bh, ch, elevation);
        function[1] = TroposphericModelUtils.mappingFunction((CalculusFieldElement)zero.add(this.awFunction.value(absLatidude)), (CalculusFieldElement)zero.add(this.bwFunction.value(absLatidude)), (CalculusFieldElement)zero.add(this.cwFunction.value(absLatidude)), elevation);
        T correction = TroposphericModelUtils.computeHeightCorrection(elevation, point.getAltitude(), field);
        function[0] = (CalculusFieldElement)function[0].add(correction);
        return function;
    }
}

