/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public enum NavigationSystem {
    GPS("GPS"),
    GLO("GLO", "Glonass"),
    GAL("GAL", "Galileo"),
    BDS("BDS", "Beidou"),
    QZS("QZS", "QZNSS"),
    SBAS("SBAS"),
    EMPTY("");

    private static final Map<String, NavigationSystem> KEYWORDS_MAP;
    private final String keyword;
    private final String name;

    private NavigationSystem(String keyword) {
        this(keyword, keyword);
    }

    private NavigationSystem(String keyword, String name) {
        this.keyword = keyword;
        this.name = name;
    }

    private String getKeyword() {
        return this.keyword;
    }

    public String toString() {
        return this.name;
    }

    public static NavigationSystem getNavigationSystem(String keyword) {
        NavigationSystem system = KEYWORDS_MAP.get(keyword);
        if (system == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_NAVIGATION_SYSTEM, keyword);
        }
        return system;
    }

    static {
        KEYWORDS_MAP = new HashMap<String, NavigationSystem>();
        for (NavigationSystem type : NavigationSystem.values()) {
            KEYWORDS_MAP.put(type.getKeyword(), type);
        }
    }
}

