/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public enum DataFormat {
    RTCM_2("RTCM 2(?:[\\.0-9]+)?"),
    RTCM_3("RTCM 3(?:[\\.0-9]+)?"),
    RTCM_SAPOS("RTCM SAPOS"),
    CMR("CMR"),
    CMR_PLUS("CMR +"),
    SAPOS_ADV("SAPOS-AdV"),
    RTCA("RTCA"),
    RAW("RAW"),
    RINEX("RINEX"),
    SP3("SP3"),
    BINEX("BINEX");

    private final Pattern pattern;

    private DataFormat(String keywordPattern) {
        this.pattern = Pattern.compile(keywordPattern);
    }

    private Pattern getPattern() {
        return this.pattern;
    }

    public static DataFormat getDataFormat(String keyword) {
        for (DataFormat format : DataFormat.values()) {
            if (!format.getPattern().matcher(keyword).matches()) continue;
            return format;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_DATA_FORMAT, keyword);
    }
}

