/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.trigger;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.events.Action;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class EventBasedManeuverTriggers
implements ManeuverTriggers,
EventHandler<EventDetector> {
    private final AbstractDetector<? extends EventDetector> startFiringDetector;
    private final AbstractDetector<? extends EventDetector> stopFiringDetector;
    private final boolean allowBackwardPropagation;
    private boolean initialized;
    private AbsoluteDate triggeredStart;
    private AbsoluteDate triggeredEnd;
    private boolean forward;

    public EventBasedManeuverTriggers(AbstractDetector<? extends EventDetector> startFiringDetector, AbstractDetector<? extends EventDetector> stopFiringDetector) {
        this(startFiringDetector, stopFiringDetector, false);
    }

    public EventBasedManeuverTriggers(AbstractDetector<? extends EventDetector> startFiringDetector, AbstractDetector<? extends EventDetector> stopFiringDetector, boolean allowBackwardPropagation) {
        if (startFiringDetector == null) {
            throw new OrekitException((Localizable)OrekitMessages.PARAMETER_NOT_SET, "stopFiringDetector", EventBasedManeuverTriggers.class.getSimpleName());
        }
        if (stopFiringDetector == null) {
            throw new OrekitException((Localizable)OrekitMessages.PARAMETER_NOT_SET, "startFiringDetector", EventBasedManeuverTriggers.class.getSimpleName());
        }
        this.startFiringDetector = startFiringDetector.withHandler(this);
        this.stopFiringDetector = stopFiringDetector.withHandler(this);
        this.allowBackwardPropagation = allowBackwardPropagation;
        this.triggeredStart = null;
        this.triggeredEnd = null;
        this.initialized = false;
        this.forward = true;
    }

    public AbstractDetector<? extends EventDetector> getStartFiringDetector() {
        return this.startFiringDetector;
    }

    public AbstractDetector<? extends EventDetector> getStopFiringDetector() {
        return this.stopFiringDetector;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        if (!this.initialized) {
            this.initialized = true;
            this.forward = target.isAfterOrEqualTo(initialState);
            if (!this.forward && !this.allowBackwardPropagation) {
                throw new OrekitException((Localizable)OrekitMessages.BACKWARD_PROPAGATION_NOT_ALLOWED, new Object[0]);
            }
            this.startFiringDetector.init(initialState, target);
            this.stopFiringDetector.init(initialState, target);
            this.checkInitialFiringState(initialState);
        }
    }

    protected void checkInitialFiringState(SpacecraftState initialState) {
        if (this.isFiringOnInitialState(initialState)) {
            this.setFiring(true, initialState.getDate());
        }
    }

    protected boolean isFiringOnInitialState(SpacecraftState initialState) {
        double insideThrustArcG = this.getStartFiringDetector().g(initialState);
        boolean isInsideThrustArc = false;
        if (insideThrustArcG == 0.0) {
            double nextSecond = this.forward ? 1.0 : -1.0;
            double nextValue = this.getStartFiringDetector().g(initialState.shiftedBy(nextSecond));
            isInsideThrustArc = nextValue > 0.0;
        } else {
            isInsideThrustArc = insideThrustArcG > 0.0;
        }
        return isInsideThrustArc;
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.of(this.getStartFiringDetector(), this.getStopFiringDetector());
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        throw new OrekitException((Localizable)OrekitMessages.FUNCTION_NOT_IMPLEMENTED, "EventBasedManeuverTriggers.getFieldEventsDetectors");
    }

    public void setFiring(boolean firing, AbsoluteDate date) {
        if (this.forward) {
            if (firing) {
                if (!date.equals(this.triggeredEnd)) {
                    this.triggeredStart = date;
                    this.triggeredEnd = null;
                }
            } else {
                this.triggeredEnd = date;
            }
        } else if (firing) {
            if (!date.equals(this.triggeredStart)) {
                this.triggeredEnd = date;
                this.triggeredStart = null;
            }
        } else {
            this.triggeredStart = date;
        }
    }

    @Override
    public boolean isFiring(AbsoluteDate date, double[] parameters) {
        return this.isFiring(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> boolean isFiring(FieldAbsoluteDate<T> date, T[] parameters) {
        return this.isFiring(date.toAbsoluteDate());
    }

    @Override
    public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
        Action action = Action.CONTINUE;
        boolean detectorManaged = this.getEventsDetectors().anyMatch(managedDetector -> managedDetector.equals(detector));
        if (detectorManaged && increasing) {
            action = Action.RESET_EVENTS;
            if (this.forward) {
                if (detector.equals(this.startFiringDetector)) {
                    this.setFiring(true, s.getDate());
                    action = Action.RESET_DERIVATIVES;
                } else if (detector.equals(this.stopFiringDetector)) {
                    this.setFiring(false, s.getDate());
                    action = Action.RESET_DERIVATIVES;
                }
            } else if (detector.equals(this.startFiringDetector)) {
                this.setFiring(false, s.getDate());
                action = Action.RESET_DERIVATIVES;
            } else if (detector.equals(this.stopFiringDetector)) {
                this.setFiring(true, s.getDate());
                action = Action.RESET_DERIVATIVES;
            }
        }
        return action;
    }

    public boolean isFiring(AbsoluteDate date) {
        if (this.forward) {
            if (this.triggeredStart == null) {
                return false;
            }
            if (date.isBefore(this.triggeredStart)) {
                return false;
            }
            if (this.triggeredEnd == null) {
                return true;
            }
            return date.isBefore(this.triggeredEnd);
        }
        if (this.triggeredEnd == null) {
            return false;
        }
        if (date.isAfter(this.triggeredEnd)) {
            return false;
        }
        if (this.triggeredStart == null) {
            return true;
        }
        return date.isAfter(this.triggeredStart);
    }

    public AbsoluteDate getTriggeredEnd() {
        return this.triggeredEnd;
    }

    public AbsoluteDate getTriggeredStart() {
        return this.triggeredStart;
    }
}

