/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

class Flattener {
    private final int degree;
    private final int order;
    private final int dropped;

    Flattener(int degree, int order) {
        this.degree = degree;
        this.order = order;
        this.dropped = (degree - order + 1) * (degree - order) / 2;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getOrder() {
        return this.order;
    }

    public int index(int n, int m) {
        if (!this.withinRange(n, m)) {
            throw new OrekitException((Localizable)OrekitMessages.WRONG_DEGREE_OR_ORDER, n, m, this.degree, this.order);
        }
        int dm = this.degree - m;
        return dm * (dm + 1) / 2 + (n - m) - this.dropped;
    }

    public int arraySize() {
        return this.index(this.degree, 0) + 1;
    }

    public boolean withinRange(int n, int m) {
        return n >= 0 && n <= this.degree && m >= 0 && m <= FastMath.min((int)n, (int)this.order);
    }

    public double[] flatten(double[][] triangular) {
        double[] flat = new double[this.arraySize()];
        for (int n = 0; n <= this.getDegree(); ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)this.getOrder()); ++m) {
                flat[this.index((int)n, (int)m)] = triangular[n][m];
            }
        }
        return flat;
    }
}

