/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.AbstractForceModel;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class LenseThirringRelativity
extends AbstractForceModel {
    private static final double J = 9.8E8;
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;
    private final Frame bodyFrame;

    public LenseThirringRelativity(double gm, Frame bodyFrame) {
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", gm, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.bodyFrame = bodyFrame;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double c2 = 8.987551787368176E16;
        double gm = parameters[0];
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        double r = p.getNorm();
        double r2 = r * r;
        Transform t = this.bodyFrame.getTransformTo(s.getFrame(), s.getDate());
        Vector3D j = t.transformVector(Vector3D.PLUS_K).scalarMultiply(9.8E8);
        return new Vector3D(3.0 * p.dotProduct((Vector)j) / r2, p.crossProduct((Vector)v), 1.0, v.crossProduct((Vector)j)).scalarMultiply(2.0 * gm / (r2 * r * 8.987551787368176E16));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        double c2 = 8.987551787368176E16;
        T gm = parameters[0];
        TimeStampedFieldPVCoordinates<T> pv = s.getPVCoordinates();
        FieldVector3D p = pv.getPosition();
        FieldVector3D v = pv.getVelocity();
        CalculusFieldElement r = p.getNorm();
        CalculusFieldElement r2 = (CalculusFieldElement)r.multiply((FieldElement)r);
        FieldTransform<T> t = this.bodyFrame.getTransformTo(s.getFrame(), s.getDate());
        FieldVector3D j = t.transformVector(Vector3D.PLUS_K).scalarMultiply(9.8E8);
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)p.dotProduct(j).multiply(3.0)).divide((FieldElement)r2), p.crossProduct(v), (CalculusFieldElement)r.getField().getOne(), v.crossProduct(j)).scalarMultiply((CalculusFieldElement)((CalculusFieldElement)gm.multiply(2.0)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)r)).multiply(8.987551787368176E16))));
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmParameterDriver);
    }
}

