/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.gnss.TimeSystem;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SP3
implements EphemerisFile<SP3Coordinate, SP3Ephemeris> {
    public static final String SP3_FRAME_CENTER_STRING = "EARTH";
    private SP3FileType type;
    private TimeSystem timeSystem;
    private AbsoluteDate epoch;
    private int gpsWeek;
    private double secondsOfWeek;
    private int julianDay;
    private double dayFraction;
    private double epochInterval;
    private int numberOfEpochs;
    private String coordinateSystem;
    private String dataUsed;
    private SP3OrbitType orbitType;
    private String orbitTypeKey;
    private String agency;
    private CartesianDerivativesFilter filter;
    private final double mu;
    private final int interpolationSamples;
    private final Function<? super String, ? extends Frame> frameBuilder;
    private Map<String, SP3Ephemeris> satellites;

    public SP3(double mu, int interpolationSamples, Function<? super String, ? extends Frame> frameBuilder) {
        this.mu = mu;
        this.interpolationSamples = interpolationSamples;
        this.frameBuilder = frameBuilder;
        this.satellites = new LinkedHashMap<String, SP3Ephemeris>();
    }

    public void setFilter(CartesianDerivativesFilter filter) {
        this.filter = filter;
    }

    public SP3FileType getType() {
        return this.type;
    }

    public void setType(SP3FileType fileType) {
        this.type = fileType;
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(TimeSystem system) {
        this.timeSystem = system;
    }

    public String getDataUsed() {
        return this.dataUsed;
    }

    public void setDataUsed(String data) {
        this.dataUsed = data;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate time) {
        this.epoch = time;
    }

    public int getGpsWeek() {
        return this.gpsWeek;
    }

    public void setGpsWeek(int week) {
        this.gpsWeek = week;
    }

    public double getSecondsOfWeek() {
        return this.secondsOfWeek;
    }

    public void setSecondsOfWeek(double seconds) {
        this.secondsOfWeek = seconds;
    }

    public int getJulianDay() {
        return this.julianDay;
    }

    public void setJulianDay(int day) {
        this.julianDay = day;
    }

    public double getDayFraction() {
        return this.dayFraction;
    }

    public void setDayFraction(double fraction) {
        this.dayFraction = fraction;
    }

    public double getEpochInterval() {
        return this.epochInterval;
    }

    public void setEpochInterval(double interval) {
        this.epochInterval = interval;
    }

    public int getNumberOfEpochs() {
        return this.numberOfEpochs;
    }

    public void setNumberOfEpochs(int epochCount) {
        this.numberOfEpochs = epochCount;
    }

    public String getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(String system) {
        this.coordinateSystem = system;
    }

    public SP3OrbitType getOrbitType() {
        return this.orbitType;
    }

    public String getOrbitTypeKey() {
        return this.orbitTypeKey;
    }

    public void setOrbitTypeKey(String oTypeKey) {
        this.orbitTypeKey = oTypeKey;
        this.orbitType = SP3OrbitType.parseType(oTypeKey);
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agencyStr) {
        this.agency = agencyStr;
    }

    public void addSatellite(String satId) {
        this.satellites.putIfAbsent(satId, new SP3Ephemeris(satId));
    }

    @Override
    public Map<String, SP3Ephemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public int getSatelliteCount() {
        return this.satellites.size();
    }

    public void setAccuracy(int index, double accuracy) {
        int n = index;
        for (SP3Ephemeris ephemeris : this.satellites.values()) {
            if (n == 0) {
                ephemeris.setAccuracy(accuracy);
                return;
            }
            --n;
        }
    }

    public double getAccuracy(int index) {
        int n = index;
        for (SP3Ephemeris ephemeris : this.satellites.values()) {
            if (n == 0) {
                return ephemeris.getAccuracy();
            }
            --n;
        }
        return Double.NaN;
    }

    public boolean containsSatellite(String satId) {
        return this.satellites.containsKey(satId);
    }

    public void addSatelliteCoordinate(String satId, SP3Coordinate coord) {
        this.satellites.get(satId).coordinates.add(coord);
    }

    public static class SP3Coordinate
    extends TimeStampedPVCoordinates {
        private static final long serialVersionUID = 20161116L;
        private final double clock;
        private final double clockRate;

        public SP3Coordinate(AbsoluteDate date, Vector3D position, double clock) {
            this(date, position, Vector3D.ZERO, clock, 0.0);
        }

        public SP3Coordinate(AbsoluteDate date, Vector3D position, Vector3D velocity, double clock, double clockRate) {
            super(date, position, velocity, Vector3D.ZERO);
            this.clock = clock;
            this.clockRate = clockRate;
        }

        public double getClockCorrection() {
            return this.clock;
        }

        public double getClockRateChange() {
            return this.clockRate;
        }
    }

    public class SP3Ephemeris
    implements EphemerisFile.SatelliteEphemeris<SP3Coordinate, SP3Ephemeris>,
    EphemerisFile.EphemerisSegment<SP3Coordinate> {
        private final String id;
        private final List<SP3Coordinate> coordinates;
        private double accuracy;

        public SP3Ephemeris(String id) {
            this.id = id;
            this.coordinates = new ArrayList<SP3Coordinate>();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getMu() {
            return SP3.this.mu;
        }

        @Override
        public Frame getFrame() {
            return (Frame)SP3.this.frameBuilder.apply(SP3.SP3_FRAME_CENTER_STRING);
        }

        @Override
        public int getInterpolationSamples() {
            return SP3.this.interpolationSamples;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return SP3.this.filter;
        }

        @Override
        public List<SP3Coordinate> getCoordinates() {
            return Collections.unmodifiableList(this.coordinates);
        }

        @Override
        public List<SP3Ephemeris> getSegments() {
            return Collections.singletonList(this);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.coordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.coordinates.get(this.coordinates.size() - 1).getDate();
        }

        @Override
        public BoundedPropagator getPropagator() {
            return EphemerisFile.EphemerisSegment.super.getPropagator();
        }

        public void setAccuracy(double accuracy) {
            this.accuracy = accuracy;
        }

        public double getAccuracy() {
            return this.accuracy;
        }
    }

    public static enum SP3OrbitType {
        FIT,
        EXT,
        BCT,
        HLM,
        OTHER;


        public static SP3OrbitType parseType(String s) {
            String normalizedString = s.trim().toUpperCase(Locale.US);
            if ("EST".equals(normalizedString)) {
                return FIT;
            }
            if ("BHN".equals(normalizedString)) {
                return FIT;
            }
            if ("PRO".equals(normalizedString)) {
                return EXT;
            }
            try {
                return SP3OrbitType.valueOf(normalizedString);
            }
            catch (IllegalArgumentException iae) {
                return OTHER;
            }
        }
    }

    public static enum SP3FileType {
        GPS,
        MIXED,
        GLONASS,
        LEO,
        GALILEO,
        SBAS,
        IRNSS,
        COMPASS,
        QZSS,
        UNDEFINED;

    }
}

