/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.io.IOException;
import java.util.List;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.aem.AemData;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemSegment;
import org.orekit.files.ccsds.ndm.adm.aem.AemWriter;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractGenerator;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.KvnGenerator;
import org.orekit.files.ccsds.utils.generation.XmlGenerator;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.files.general.AttitudeEphemerisFileWriter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AttitudeWriter
implements AttitudeEphemerisFileWriter {
    private final AemWriter writer;
    private final Header header;
    private final AemMetadata metadata;
    private final FileFormat fileFormat;
    private final String outputName;
    private final int unitsColumn;

    public AttitudeWriter(AemWriter writer, Header header, AemMetadata template, FileFormat fileFormat, String outputName, int unitsColumn) {
        this.writer = writer;
        this.header = header;
        this.metadata = template.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.fileFormat = fileFormat;
        this.outputName = outputName;
        this.unitsColumn = unitsColumn;
    }

    @Override
    public <C extends TimeStampedAngularCoordinates, S extends AttitudeEphemerisFile.AttitudeEphemerisSegment<C>> void write(Appendable appendable, AttitudeEphemerisFile<C, S> ephemerisFile) throws IOException {
        if (appendable == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        AttitudeEphemerisFile.SatelliteAttitudeEphemeris<C, S> satEphem = ephemerisFile.getSatellites().get(this.metadata.getObjectID());
        if (satEphem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.VALUE_NOT_FOUND, this.metadata.getObjectID(), "ephemerisFile");
        }
        List<S> segments = satEphem.getSegments();
        if (segments.isEmpty()) {
            return;
        }
        try (AbstractGenerator generator = this.fileFormat == FileFormat.KVN ? new KvnGenerator(appendable, 20, this.outputName, this.unitsColumn) : new XmlGenerator(appendable, 2, this.outputName, this.unitsColumn > 0);){
            this.writer.writeHeader(generator, this.header);
            for (AttitudeEphemerisFile.AttitudeEphemerisSegment segment : segments) {
                this.writeSegment(generator, segment);
            }
            this.writer.writeFooter(generator);
        }
    }

    private <C extends TimeStampedAngularCoordinates, S extends AttitudeEphemerisFile.AttitudeEphemerisSegment<C>> void writeSegment(Generator generator, S segment) throws IOException {
        this.metadata.setStartTime(segment.getStart());
        this.metadata.setStopTime(segment.getStop());
        if (this.metadata.getEndpoints().getFrameA() == null || this.metadata.getEndpoints().getFrameA().asSpacecraftBodyFrame() == null) {
            this.metadata.getEndpoints().setFrameA(FrameFacade.map(segment.getReferenceFrame()));
        } else {
            this.metadata.getEndpoints().setFrameB(FrameFacade.map(segment.getReferenceFrame()));
        }
        this.metadata.setInterpolationMethod(segment.getInterpolationMethod());
        this.metadata.setInterpolationDegree(segment.getInterpolationSamples() - 1);
        this.writer.writeMetadata(generator, this.metadata);
        this.writer.startAttitudeBlock(generator);
        if (segment instanceof AemSegment) {
            generator.writeComments(((AemData)((AemSegment)segment).getData()).getComments());
        }
        for (TimeStampedAngularCoordinates coordinates : segment.getAngularCoordinates()) {
            this.writer.writeAttitudeEphemerisLine(generator, this.metadata, coordinates);
        }
        this.writer.endAttitudeBlock(generator);
    }
}

