/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.modifiers.TroposphericGradientConverter;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class RangeRateTroposphericDelayModifier
implements EstimationModifier<RangeRate> {
    private final DiscreteTroposphericModel tropoModel;
    private final double fTwoWay;

    public RangeRateTroposphericDelayModifier(DiscreteTroposphericModel model, boolean tw) {
        this.tropoModel = model;
        this.fTwoWay = tw ? 2.0 : 1.0;
    }

    public double rangeRateErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        double dt = 10.0;
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation1 = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation1 > 0.0) {
            double d1 = this.tropoModel.pathDelay(elevation1, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state.getDate());
            SpacecraftState state2 = state.shiftedBy(10.0);
            Vector3D position2 = state2.getPVCoordinates().getPosition();
            double elevation2 = station.getBaseFrame().getElevation(position2, state2.getFrame(), state2.getDate());
            double d2 = this.tropoModel.pathDelay(elevation2, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state2.getDate());
            return this.fTwoWay * (d2 - d1) / 10.0;
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T rangeRateErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        double dt = 10.0;
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object elevation1 = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation1.getReal() > 0.0) {
            CalculusFieldElement d1 = this.tropoModel.pathDelay((CalculusFieldElement)elevation1, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, state.getDate());
            FieldTimeInterpolable state2 = state.shiftedBy(10.0);
            FieldVector3D position2 = ((FieldSpacecraftState)state2).getPVCoordinates().getPosition();
            Object elevation2 = station.getBaseFrame().getElevation(position2, ((FieldSpacecraftState)state2).getFrame(), ((FieldSpacecraftState)state2).getDate());
            CalculusFieldElement d2 = this.tropoModel.pathDelay((CalculusFieldElement)elevation2, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, ((FieldSpacecraftState)state2).getDate());
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d2.subtract((FieldElement)d1)).divide(10.0)).multiply(this.fTwoWay));
        }
        return (T)zero;
    }

    private double[][] rangeRateErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double rangeRateErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return RangeRateTroposphericDelayModifier.this.rangeRateErrorTroposphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeRateErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) {
        double parameterDerivative;
        RangeRate measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        TroposphericGradientConverter converter = new TroposphericGradientConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.tropoModel);
        Gradient[] gParameters = converter.getParameters(gState, this.tropoModel);
        Gradient gDelay = (Gradient)this.rangeRateErrorTroposphericModel(station, gState, (CalculusFieldElement[])gParameters);
        double[] derivatives = gDelay.getGradient();
        double[][] djac = this.rangeRateErrorJacobianState(derivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] dDelaydP = this.rangeRateErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += dDelaydP[index]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeRateErrorParameterDerivative(station, driver, state));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + gDelay.getReal();
        estimated.setEstimatedValue(newValue);
    }
}

