/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class PhaseBuilder
extends AbstractMeasurementBuilder<Phase> {
    private final GroundStation station;
    private final double wavelength;

    public PhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation station, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.station = station;
        this.wavelength = wavelength;
    }

    @Override
    public Phase build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{states[satellite.getPropagatorIndex()]};
        Phase dummy = new Phase(this.station, relevant[0].getDate(), Double.NaN, this.wavelength, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double phase = dummy.estimate(0, 0, relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            phase += noise[0];
        }
        Phase measurement = new Phase(this.station, relevant[0].getDate(), phase, this.wavelength, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

