/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularAzEl
extends AbstractMeasurement<AngularAzEl> {
    private final GroundStation station;

    public AngularAzEl(GroundStation station, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(date, angular, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        this.station = station;
    }

    public GroundStation getStation() {
        return this.station;
    }

    @Override
    protected EstimatedMeasurement<AngularAzEl> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        GradientField field = GradientField.getField((int)nbParams);
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = AngularAzEl.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> downlinkDateDS = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(downlinkDateDS, zero, zero, zero));
        FieldVector3D<Gradient> east = offsetToInertialDownlink.transformVector((FieldVector3D<Gradient>)FieldVector3D.getPlusI((Field)field));
        FieldVector3D<Gradient> north = offsetToInertialDownlink.transformVector((FieldVector3D<Gradient>)FieldVector3D.getPlusJ((Field)field));
        FieldVector3D<Gradient> zenith = offsetToInertialDownlink.transformVector((FieldVector3D<Gradient>)FieldVector3D.getPlusK((Field)field));
        Gradient tauD = AngularAzEl.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        Gradient delta = downlinkDateDS.durationFrom(state.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((CalculusFieldElement)deltaMTauD);
        FieldVector3D staSat = transitStateDS.getPosition().subtract(stationDownlink.getPosition());
        Gradient baseAzimuth = ((Gradient)staSat.dotProduct(east)).atan2((Gradient)staSat.dotProduct(north));
        double twoPiWrap = MathUtils.normalizeAngle((double)baseAzimuth.getReal(), (double)this.getObservedValue()[0]) - baseAzimuth.getReal();
        Gradient azimuth = baseAzimuth.add(twoPiWrap);
        Gradient elevation = ((Gradient)staSat.dotProduct(zenith)).divide((Gradient)staSat.getNorm()).asin();
        EstimatedMeasurement<AngularAzEl> estimated = new EstimatedMeasurement<AngularAzEl>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        estimated.setEstimatedValue(azimuth.getValue(), elevation.getValue());
        double[] azDerivatives = azimuth.getGradient();
        double[] elDerivatives = elevation.getGradient();
        estimated.setStateDerivatives(0, Arrays.copyOfRange(azDerivatives, 0, 6), Arrays.copyOfRange(elDerivatives, 0, 6));
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, azDerivatives[index], elDerivatives[index]);
        }
        return estimated;
    }
}

