/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.DormandPrince54FieldStateInterpolator;
import org.hipparchus.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class DormandPrince54FieldIntegrator<T extends CalculusFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    public DormandPrince54FieldIntegrator(Field<T> field, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, "Dormand-Prince 5(4)", 6, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public DormandPrince54FieldIntegrator(Field<T> field, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, "Dormand-Prince 5(4)", 6, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)6);
        c[0] = this.fraction(1, 5);
        c[1] = this.fraction(3, 10);
        c[2] = this.fraction(4, 5);
        c[3] = this.fraction(8, 9);
        c[4] = (CalculusFieldElement)this.getField().getOne();
        c[5] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)6, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = this.fraction(1, 5);
        a[1][0] = this.fraction(3, 40);
        a[1][1] = this.fraction(9, 40);
        a[2][0] = this.fraction(44, 45);
        a[2][1] = this.fraction(-56, 15);
        a[2][2] = this.fraction(32, 9);
        a[3][0] = this.fraction(19372, 6561);
        a[3][1] = this.fraction(-25360, 2187);
        a[3][2] = this.fraction(64448, 6561);
        a[3][3] = this.fraction(-212, 729);
        a[4][0] = this.fraction(9017, 3168);
        a[4][1] = this.fraction(-355, 33);
        a[4][2] = this.fraction(46732, 5247);
        a[4][3] = this.fraction(49, 176);
        a[4][4] = this.fraction(-5103, 18656);
        a[5][0] = this.fraction(35, 384);
        a[5][1] = (CalculusFieldElement)this.getField().getZero();
        a[5][2] = this.fraction(500, 1113);
        a[5][3] = this.fraction(125, 192);
        a[5][4] = this.fraction(-2187, 6784);
        a[5][5] = this.fraction(11, 84);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)7);
        b[0] = this.fraction(35, 384);
        b[1] = (CalculusFieldElement)this.getField().getZero();
        b[2] = this.fraction(500, 1113);
        b[3] = this.fraction(125, 192);
        b[4] = this.fraction(-2187, 6784);
        b[5] = this.fraction(11, 84);
        b[6] = (CalculusFieldElement)this.getField().getZero();
        return b;
    }

    @Override
    protected DormandPrince54FieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new DormandPrince54FieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected double estimateError(T[][] yDotK, T[] y0, T[] y1, T h) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error = 0.0;
        for (int j = 0; j < helper.getMainSetDimension(); ++j) {
            double errSum = 0.0012326388888888888 * yDotK[0][j].getReal() + -0.0042527702905061394 * yDotK[2][j].getReal() + 0.03697916666666667 * yDotK[3][j].getReal() + -0.05086379716981132 * yDotK[4][j].getReal() + 0.0419047619047619 * yDotK[5][j].getReal() + -0.025 * yDotK[6][j].getReal();
            double tol = helper.getTolerance(j, FastMath.max((double)FastMath.abs((double)y0[j].getReal()), (double)FastMath.abs((double)y1[j].getReal())));
            double ratio = h.getReal() * errSum / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
    }
}

