/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.UTCScale;

public class GLONASSScale
implements TimeScale {
    private static final long serialVersionUID = 20160331L;
    private static final double OFFSET = 10800.0;
    private final UTCScale utc;

    GLONASSScale(UTCScale utc) {
        this.utc = utc;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return 10800.0 + this.utc.offsetFromTAI(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)this.utc.offsetFromTAI(date).add(10800.0));
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        DateTimeComponents utcComponents = new DateTimeComponents(new DateTimeComponents(date, time), -10800.0);
        return this.utc.offsetToTAI(utcComponents.getDate(), utcComponents.getTime()) - 10800.0;
    }

    @Override
    public boolean insideLeap(AbsoluteDate date) {
        return this.utc.insideLeap(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> boolean insideLeap(FieldAbsoluteDate<T> date) {
        return this.utc.insideLeap(date);
    }

    @Override
    public int minuteDuration(AbsoluteDate date) {
        return this.utc.minuteDuration(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> int minuteDuration(FieldAbsoluteDate<T> date) {
        return this.utc.minuteDuration(date);
    }

    @Override
    public double getLeap(AbsoluteDate date) {
        return this.utc.getLeap(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getLeap(FieldAbsoluteDate<T> date) {
        return this.utc.getLeap(date);
    }

    @Override
    public String getName() {
        return "GLONASS";
    }

    public String toString() {
        return this.getName();
    }
}

