/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.NewcombOperators;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.PolynomialFunctionMatrix;

public class HansenTesseralLinear {
    private static final int SLICE = 10;
    private PolynomialFunction[][] mpvec;
    private PolynomialFunction[][] mpvecDeriv;
    private double[][] hansenRoot;
    private double[][] hansenDerivRoot;
    private int Nmin;
    private int N0;
    private int s;
    private int j;
    private int numSlices;
    private int offset;
    private HansenCoefficientsBySeries[] hansenInit;

    public HansenTesseralLinear(int nMax, int s, int j, int n0, int maxHansen) {
        this.offset = nMax + 1;
        this.Nmin = -nMax - 1;
        this.N0 = -n0 - 4;
        this.s = s;
        this.j = j;
        int maxRoots = FastMath.min((int)4, (int)(this.N0 - this.Nmin + 4));
        this.hansenInit = new HansenCoefficientsBySeries[maxRoots];
        for (int i = 0; i < maxRoots; ++i) {
            this.hansenInit[i] = new HansenCoefficientsBySeries(this.N0 - i + 3, s, j, maxHansen);
        }
        int size = this.N0 - this.Nmin;
        this.numSlices = (int)FastMath.max((double)FastMath.ceil((double)((double)size / 10.0)), (double)1.0);
        this.hansenRoot = new double[this.numSlices][4];
        this.hansenDerivRoot = new double[this.numSlices][4];
        if (size > 0) {
            this.mpvec = new PolynomialFunction[size][];
            this.mpvecDeriv = new PolynomialFunction[size][];
            this.generatePolynomials();
        }
    }

    private PolynomialFunction a(int mnm1) {
        double r1 = ((double)mnm1 + 2.0) * (2.0 * (double)mnm1 + 5.0);
        double r2 = (2.0 + (double)mnm1 + (double)this.s) * (2.0 + (double)mnm1 - (double)this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, r1 / r2});
    }

    private PolynomialFunction b(int mnm1) {
        double r2 = (2.0 + (double)mnm1 + (double)this.s) * (2.0 + (double)mnm1 - (double)this.s);
        double d1 = ((double)mnm1 + 3.0) * 2.0 * (double)this.j * (double)this.s / (r2 * ((double)mnm1 + 4.0));
        double d2 = ((double)mnm1 + 3.0) * ((double)mnm1 + 2.0) / r2;
        return new PolynomialFunction(new double[]{0.0, -d1, -d2});
    }

    private PolynomialFunction c(int mnm1) {
        double r1 = (double)(this.j * this.j) * ((double)mnm1 + 2.0);
        double r2 = ((double)mnm1 + 4.0) * (2.0 + (double)mnm1 + (double)this.s) * (2.0 + (double)mnm1 - (double)this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, r1 / r2});
    }

    private PolynomialFunction d(int mnm1) {
        return new PolynomialFunction(new double[]{0.0, 0.0, 1.0});
    }

    private PolynomialFunction f(int n) {
        double r1 = ((double)n + 3.0) * (double)this.j * (double)this.s;
        double r2 = ((double)n + 4.0) * (2.0 + (double)n + (double)this.s) * (2.0 + (double)n - (double)this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, 0.0, r1 / r2});
    }

    private void generatePolynomials() {
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix4();
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix4();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix4();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix4();
        a.setMatrixLine(0, new PolynomialFunction[]{HansenUtilities.ZERO, HansenUtilities.ONE, HansenUtilities.ZERO, HansenUtilities.ZERO});
        a.setMatrixLine(1, new PolynomialFunction[]{HansenUtilities.ZERO, HansenUtilities.ZERO, HansenUtilities.ONE, HansenUtilities.ZERO});
        a.setMatrixLine(2, new PolynomialFunction[]{HansenUtilities.ZERO, HansenUtilities.ZERO, HansenUtilities.ZERO, HansenUtilities.ONE});
        int sliceCounter = 0;
        for (int i = this.N0 - 1; i > this.Nmin - 1; --i) {
            int index = i + this.offset;
            a.setMatrixLine(3, new PolynomialFunction[]{this.c(i), HansenUtilities.ZERO, this.b(i), this.a(i)});
            A = A.multiply(a);
            this.mpvec[index] = A.getMatrixLine(3);
            D = D.multiply(a);
            B.setMatrixLine(3, new PolynomialFunction[]{HansenUtilities.ZERO, this.f(i), HansenUtilities.ZERO, this.d(i)});
            D = D.add(A.multiply(B));
            this.mpvecDeriv[index] = D.getMatrixLine(3);
            if (++sliceCounter % 10 != 0) continue;
            A = HansenUtilities.buildIdentityMatrix4();
            D = HansenUtilities.buildZeroMatrix4();
        }
    }

    public void computeInitValues(double e2, double chi, double chi2) {
        int i;
        int maxRoots = FastMath.min((int)4, (int)(this.N0 - this.Nmin + 4));
        for (i = 0; i < maxRoots; ++i) {
            Gradient hansenKernel = this.hansenInit[i].getValueGradient(e2, chi, chi2);
            this.hansenRoot[0][i] = hansenKernel.getValue();
            this.hansenDerivRoot[0][i] = hansenKernel.getPartialDerivative(0);
        }
        for (i = 1; i < this.numSlices; ++i) {
            for (int k = 0; k < 4; ++k) {
                PolynomialFunction[] mv = this.mpvec[this.N0 - i * 10 - k + 3 + this.offset];
                PolynomialFunction[] sv = this.mpvecDeriv[this.N0 - i * 10 - k + 3 + this.offset];
                this.hansenDerivRoot[i][k] = mv[3].value(chi) * this.hansenDerivRoot[i - 1][3] + mv[2].value(chi) * this.hansenDerivRoot[i - 1][2] + mv[1].value(chi) * this.hansenDerivRoot[i - 1][1] + mv[0].value(chi) * this.hansenDerivRoot[i - 1][0] + sv[3].value(chi) * this.hansenRoot[i - 1][3] + sv[2].value(chi) * this.hansenRoot[i - 1][2] + sv[1].value(chi) * this.hansenRoot[i - 1][1] + sv[0].value(chi) * this.hansenRoot[i - 1][0];
                this.hansenRoot[i][k] = mv[3].value(chi) * this.hansenRoot[i - 1][3] + mv[2].value(chi) * this.hansenRoot[i - 1][2] + mv[1].value(chi) * this.hansenRoot[i - 1][1] + mv[0].value(chi) * this.hansenRoot[i - 1][0];
            }
        }
    }

    public double getValue(int mnm1, double chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n + this.N0 + 4) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n + this.N0 + 4) % 10;
            if (indexInSlice <= 3) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        return v[3].value(chi) * this.hansenRoot[sliceNo][3] + v[2].value(chi) * this.hansenRoot[sliceNo][2] + v[1].value(chi) * this.hansenRoot[sliceNo][1] + v[0].value(chi) * this.hansenRoot[sliceNo][0];
    }

    public double getDerivative(int mnm1, double chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n + this.N0 + 4) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n + this.N0 + 4) % 10;
            if (indexInSlice <= 3) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        PolynomialFunction[] vv = this.mpvecDeriv[mnm1 + this.offset];
        return v[3].value(chi) * this.hansenDerivRoot[sliceNo][3] + v[2].value(chi) * this.hansenDerivRoot[sliceNo][2] + v[1].value(chi) * this.hansenDerivRoot[sliceNo][1] + v[0].value(chi) * this.hansenDerivRoot[sliceNo][0] + vv[3].value(chi) * this.hansenRoot[sliceNo][3] + vv[2].value(chi) * this.hansenRoot[sliceNo][2] + vv[1].value(chi) * this.hansenRoot[sliceNo][1] + vv[0].value(chi) * this.hansenRoot[sliceNo][0];
    }

    private static class HansenCoefficientsBySeries {
        private final int mnm1;
        private final int s;
        private final int j;
        private final int maxNewcomb;
        private PolynomialFunction polynomial;

        HansenCoefficientsBySeries(int mnm1, int s, int j, int maxHansen) {
            this.mnm1 = mnm1;
            this.s = s;
            this.j = j;
            this.maxNewcomb = maxHansen;
            this.polynomial = this.generatePolynomial();
        }

        public Gradient getValueGradient(double e2, double chi, double chi2) {
            Gradient serie = (Gradient)this.polynomial.value((Derivative)Gradient.variable((int)1, (int)0, (double)e2));
            double value = FastMath.pow((double)chi2, (int)(-this.mnm1 - 1)) * serie.getValue() / chi;
            double coef = -((double)this.mnm1 + 1.5);
            double derivative = coef * chi2 * value + FastMath.pow((double)chi2, (int)(-this.mnm1 - 1)) * serie.getPartialDerivative(0) / chi;
            return new Gradient(value, new double[]{derivative});
        }

        private PolynomialFunction generatePolynomial() {
            int aHT = FastMath.max((int)(this.j - this.s), (int)0);
            int bHT = FastMath.max((int)(this.s - this.j), (int)0);
            double[] coefficients = new double[this.maxNewcomb + 1];
            for (int alphaHT = 0; alphaHT <= this.maxNewcomb; ++alphaHT) {
                coefficients[alphaHT] = NewcombOperators.getValue(alphaHT + aHT, alphaHT + bHT, this.mnm1, this.s);
            }
            return new PolynomialFunction(coefficients);
        }
    }
}

