/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCircularOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T> {
    private final T a;
    private final T ex;
    private final T ey;
    private final T i;
    private final T raan;
    private final T alphaV;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T iDot;
    private final T raanDot;
    private final T alphaVDot;
    private FieldPVCoordinates<T> partialPV;
    private final T one;
    private final T zero;

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, i, raan, alpha, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, T aDot, T exDot, T eyDot, T iDot, T raanDot, T alphaDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.i = i;
        this.iDot = iDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.one = (CalculusFieldElement)a.getField().getOne();
        this.zero = (CalculusFieldElement)a.getField().getZero();
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1 alphavUD;
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(ex, exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(ey, eyDot);
            FieldUnivariateDerivative1 alphaUD = new FieldUnivariateDerivative1(alpha, alphaDot);
            switch (type) {
                case MEAN: {
                    alphavUD = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alphaUD, exUD, eyUD), exUD, eyUD);
                    break;
                }
                case ECCENTRIC: {
                    alphavUD = FieldCircularOrbit.eccentricToTrue(alphaUD, exUD, eyUD);
                    break;
                }
                case TRUE: {
                    alphavUD = alphaUD;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.alphaV = alphavUD.getValue();
            this.alphaVDot = alphavUD.getDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.alphaV = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alpha, ex, ey), ex, ey);
                    break;
                }
                case ECCENTRIC: {
                    this.alphaV = FieldCircularOrbit.eccentricToTrue(alpha, ex, ey);
                    break;
                }
                case TRUE: {
                    this.alphaV = alpha;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.alphaVDot = null;
        }
        this.partialPV = null;
    }

    public FieldCircularOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement V2 = pvV.getNormSq();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)V2)).divide(mu);
        this.zero = (CalculusFieldElement)r.getField().getZero();
        this.one = (CalculusFieldElement)r.getField().getOne();
        if (rV2OnMu.getReal() > 2.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = (CalculusFieldElement)r.divide(((CalculusFieldElement)rV2OnMu.negate()).add(2.0));
        FieldVector3D momentum = pvCoordinates.getMomentum();
        FieldVector3D plusK = FieldVector3D.getPlusK((Field)r.getField());
        this.i = FieldVector3D.angle(momentum, (FieldVector3D)plusK);
        FieldVector3D node = FieldVector3D.crossProduct((FieldVector3D)plusK, momentum);
        this.raan = (CalculusFieldElement)node.getY().atan2((FieldElement)node.getX());
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        FieldSinCos scI = FastMath.sinCos(this.i);
        CalculusFieldElement xP = pvP.getX();
        CalculusFieldElement yP = pvP.getY();
        CalculusFieldElement zP = pvP.getZ();
        CalculusFieldElement x2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xP.multiply((FieldElement)scRaan.cos())).add(yP.multiply((FieldElement)scRaan.sin()))).divide(this.a);
        CalculusFieldElement y2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yP.multiply((FieldElement)scRaan.cos())).subtract(xP.multiply((FieldElement)scRaan.sin()))).multiply((FieldElement)scI.cos())).add(zP.multiply((FieldElement)scI.sin()))).divide(this.a);
        CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((CalculusFieldElement)this.a.multiply(mu)).sqrt());
        CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)eCE.multiply((FieldElement)eCE)).add(eSE.multiply((FieldElement)eSE));
        CalculusFieldElement f = (CalculusFieldElement)eCE.subtract((FieldElement)e2);
        CalculusFieldElement g = (CalculusFieldElement)eSE.multiply(((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt());
        CalculusFieldElement aOnR = (CalculusFieldElement)this.a.divide((FieldElement)r);
        CalculusFieldElement a2OnR2 = (CalculusFieldElement)aOnR.multiply((FieldElement)aOnR);
        this.ex = (CalculusFieldElement)a2OnR2.multiply(((CalculusFieldElement)f.multiply((FieldElement)x2)).add(g.multiply((FieldElement)y2)));
        this.ey = (CalculusFieldElement)a2OnR2.multiply(((CalculusFieldElement)f.multiply((FieldElement)y2)).subtract(g.multiply((FieldElement)x2)));
        CalculusFieldElement beta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).negate()).add(1.0)).sqrt()).add(1.0)).reciprocal();
        this.alphaV = FieldCircularOrbit.eccentricToTrue((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y2.add(this.ey)).add(((CalculusFieldElement)eSE.multiply((FieldElement)beta)).multiply(this.ex))).atan2(((CalculusFieldElement)x2.add(this.ex)).subtract(((CalculusFieldElement)eSE.multiply((FieldElement)beta)).multiply(this.ey))), this.ex, this.ey);
        this.partialPV = pvCoordinates;
        if (FieldCircularOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            CalculusFieldElement aX = nonKeplerianAcceleration.getX();
            CalculusFieldElement aY = nonKeplerianAcceleration.getY();
            CalculusFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[0][3].multiply((FieldElement)aX)).add(jacobian[0][4].multiply((FieldElement)aY))).add(jacobian[0][5].multiply((FieldElement)aZ));
            this.exDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[1][3].multiply((FieldElement)aX)).add(jacobian[1][4].multiply((FieldElement)aY))).add(jacobian[1][5].multiply((FieldElement)aZ));
            this.eyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[2][3].multiply((FieldElement)aX)).add(jacobian[2][4].multiply((FieldElement)aY))).add(jacobian[2][5].multiply((FieldElement)aZ));
            this.iDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[3][3].multiply((FieldElement)aX)).add(jacobian[3][4].multiply((FieldElement)aY))).add(jacobian[3][5].multiply((FieldElement)aZ));
            this.raanDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[4][3].multiply((FieldElement)aX)).add(jacobian[4][4].multiply((FieldElement)aY))).add(jacobian[4][5].multiply((FieldElement)aZ));
            CalculusFieldElement alphaMDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().add(jacobian[5][3].multiply((FieldElement)aX))).add(jacobian[5][4].multiply((FieldElement)aY))).add(jacobian[5][5].multiply((FieldElement)aZ));
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
            FieldUnivariateDerivative1 alphaMUD = new FieldUnivariateDerivative1(this.getAlphaM(), alphaMDot);
            FieldUnivariateDerivative1 alphavUD = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alphaMUD, exUD, eyUD), exUD, eyUD);
            this.alphaVDot = alphavUD.getDerivative(1);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.alphaVDot = null;
        }
    }

    public FieldCircularOrbit(FieldPVCoordinates<T> PVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, PVCoordinates2), frame, mu);
    }

    public FieldCircularOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.i = op.getI();
        T hx = op.getHx();
        T hy = op.getHy();
        CalculusFieldElement h2 = (CalculusFieldElement)((CalculusFieldElement)hx.multiply(hx)).add(hy.multiply(hy));
        CalculusFieldElement h = (CalculusFieldElement)h2.sqrt();
        this.raan = (CalculusFieldElement)hy.atan2(hx);
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        CalculusFieldElement cosRaan = h.getReal() == 0.0 ? (CalculusFieldElement)scRaan.cos() : (CalculusFieldElement)hx.divide((FieldElement)h);
        CalculusFieldElement sinRaan = h.getReal() == 0.0 ? (CalculusFieldElement)scRaan.sin() : (CalculusFieldElement)hy.divide((FieldElement)h);
        T equiEx = op.getEquinoctialEx();
        T equiEy = op.getEquinoctialEy();
        this.ex = (CalculusFieldElement)((CalculusFieldElement)equiEx.multiply((FieldElement)cosRaan)).add(equiEy.multiply((FieldElement)sinRaan));
        this.ey = (CalculusFieldElement)((CalculusFieldElement)equiEy.multiply((FieldElement)cosRaan)).subtract(equiEx.multiply((FieldElement)sinRaan));
        this.alphaV = (CalculusFieldElement)op.getLv().subtract(this.raan);
        if (op.hasDerivatives()) {
            this.aDot = op.getADot();
            T hxDot = op.getHxDot();
            T hyDot = op.getHyDot();
            this.iDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosRaan.multiply(hxDot)).add(sinRaan.multiply(hyDot))).multiply(2)).divide(h2.add(1.0));
            this.raanDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx.multiply(hyDot)).subtract(hy.multiply(hxDot))).divide((FieldElement)h2);
            T equiExDot = op.getEquinoctialExDot();
            T equiEyDot = op.getEquinoctialEyDot();
            this.exDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)equiExDot.add(equiEy.multiply(this.raanDot))).multiply((FieldElement)cosRaan)).add(((CalculusFieldElement)equiEyDot.subtract(equiEx.multiply(this.raanDot))).multiply((FieldElement)sinRaan));
            this.eyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)equiEyDot.subtract(equiEx.multiply(this.raanDot))).multiply((FieldElement)cosRaan)).subtract(((CalculusFieldElement)equiExDot.add(equiEy.multiply(this.raanDot))).multiply((FieldElement)sinRaan));
            this.alphaVDot = (CalculusFieldElement)op.getLvDot().subtract(this.raanDot);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.alphaVDot = null;
        }
        this.partialPV = null;
        this.one = (CalculusFieldElement)this.a.getField().getOne();
        this.zero = (CalculusFieldElement)this.a.getField().getZero();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CIRCULAR;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sc.cos())).subtract(this.ey.multiply((FieldElement)sc.sin())));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.exDot.subtract(this.ey.multiply(this.raanDot))).multiply((FieldElement)sc.cos())).subtract(((CalculusFieldElement)this.eyDot.add(this.ex.multiply(this.raanDot))).multiply((FieldElement)sc.sin())));
    }

    @Override
    public T getEquinoctialEy() {
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)sc.cos())).add(this.ex.multiply((FieldElement)sc.sin())));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.eyDot.add(this.ex.multiply(this.raanDot))).multiply((FieldElement)sc.cos())).add(((CalculusFieldElement)this.exDot.subtract(this.ey.multiply(this.raanDot))).multiply((FieldElement)sc.sin())));
    }

    public T getCircularEx() {
        return this.ex;
    }

    public T getCircularExDot() {
        return this.exDot;
    }

    public T getCircularEy() {
        return this.ey;
    }

    public T getCircularEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.cos()).multiply(((CalculusFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        CalculusFieldElement tan = (CalculusFieldElement)((CalculusFieldElement)this.i.multiply(0.5)).tan();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply(0.5)).multiply(((CalculusFieldElement)tan.multiply((FieldElement)tan)).add(1.0))).multiply(this.iDot)).subtract(((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply((FieldElement)tan)).multiply(this.raanDot)));
    }

    @Override
    public T getHy() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.sin()).multiply(((CalculusFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        CalculusFieldElement tan = (CalculusFieldElement)((CalculusFieldElement)this.i.multiply(0.5)).tan();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply(0.5)).multiply(((CalculusFieldElement)tan.multiply((FieldElement)tan)).add(1.0))).multiply(this.iDot)).add(((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply((FieldElement)tan)).multiply(this.raanDot)));
    }

    public T getAlphaV() {
        return this.alphaV;
    }

    public T getAlphaVDot() {
        return this.alphaVDot;
    }

    public T getAlphaE() {
        return FieldCircularOrbit.trueToEccentric(this.alphaV, this.ex, this.ey);
    }

    public T getAlphaEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 alphaVUD = new FieldUnivariateDerivative1(this.alphaV, this.alphaVDot);
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 alphaEUD = FieldCircularOrbit.trueToEccentric(alphaVUD, exUD, eyUD);
        return (T)alphaEUD.getDerivative(1);
    }

    public T getAlphaM() {
        return FieldCircularOrbit.eccentricToMean(FieldCircularOrbit.trueToEccentric(this.alphaV, this.ex, this.ey), this.ex, this.ey);
    }

    public T getAlphaMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 alphaVUD = new FieldUnivariateDerivative1(this.alphaV, this.alphaVDot);
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 alphaMUD = FieldCircularOrbit.eccentricToMean(FieldCircularOrbit.trueToEccentric(alphaVUD, exUD, eyUD), exUD, eyUD);
        return (T)alphaMUD.getDerivative(1);
    }

    public T getAlpha(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getAlphaM() : (type == PositionAngle.ECCENTRIC ? this.getAlphaE() : this.getAlphaV());
    }

    public T getAlphaDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getAlphaMDot() : (type == PositionAngle.ECCENTRIC ? this.getAlphaEDot() : this.getAlphaVDot());
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToTrue(T alphaE, T ex, T ey) {
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        FieldSinCos scAlphaE = FastMath.sinCos(alphaE);
        return (T)((CalculusFieldElement)alphaE.add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)scAlphaE.sin())).subtract(ey.multiply((FieldElement)scAlphaE.cos()))).divide(((CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).subtract(ex.multiply((FieldElement)scAlphaE.cos()))).subtract(ey.multiply((FieldElement)scAlphaE.sin())))).atan()).multiply(2)));
    }

    public static <T extends CalculusFieldElement<T>> T trueToEccentric(T alphaV, T ex, T ey) {
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        FieldSinCos scAlphaV = FastMath.sinCos(alphaV);
        return (T)((CalculusFieldElement)alphaV.add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ey.multiply((FieldElement)scAlphaV.cos())).subtract(ex.multiply((FieldElement)scAlphaV.sin()))).divide(((CalculusFieldElement)epsilon.add(1.0)).add(((CalculusFieldElement)ex.multiply((FieldElement)scAlphaV.cos())).add(ey.multiply((FieldElement)scAlphaV.sin()))))).atan()).multiply(2)));
    }

    public static <T extends CalculusFieldElement<T>> T meanToEccentric(T alphaM, T ex, T ey) {
        Object alphaE = alphaM;
        CalculusFieldElement shift = (CalculusFieldElement)alphaM.getField().getZero();
        CalculusFieldElement alphaEMalphaM = (CalculusFieldElement)alphaM.getField().getZero();
        FieldSinCos scAlphaE = FastMath.sinCos(alphaE);
        int iter = 0;
        do {
            CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)scAlphaE.sin())).subtract(ey.multiply((FieldElement)scAlphaE.cos()));
            CalculusFieldElement f1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.negate()).multiply((FieldElement)scAlphaE.cos())).subtract(ey.multiply((FieldElement)scAlphaE.sin()))).add(1.0);
            CalculusFieldElement f0 = (CalculusFieldElement)alphaEMalphaM.subtract((FieldElement)f2);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2);
            shift = (CalculusFieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f12)).divide(((CalculusFieldElement)f1.multiply((FieldElement)f12)).subtract(f0.multiply((FieldElement)f2)));
            alphaEMalphaM = (CalculusFieldElement)alphaEMalphaM.subtract((FieldElement)shift);
            alphaE = (CalculusFieldElement)alphaM.add((FieldElement)alphaEMalphaM);
            scAlphaE = FastMath.sinCos(alphaE);
        } while (++iter < 50 && FastMath.abs((double)shift.getReal()) > 1.0E-12);
        return alphaE;
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToMean(T alphaE, T ex, T ey) {
        FieldSinCos scAlphaE = FastMath.sinCos(alphaE);
        return (T)((CalculusFieldElement)alphaE.subtract(((CalculusFieldElement)ex.multiply((FieldElement)scAlphaE.sin())).subtract(ey.multiply((FieldElement)scAlphaE.cos()))));
    }

    @Override
    public T getE() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.exDot)).add(this.ey.multiply(this.eyDot))).divide(this.getE()));
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    @Override
    public T getLv() {
        return (T)((CalculusFieldElement)this.alphaV.add(this.raan));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)this.alphaVDot.add(this.raanDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((CalculusFieldElement)this.getAlphaE().add(this.raan));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)this.getAlphaEDot().add(this.raanDot) : null);
    }

    @Override
    public T getLM() {
        return (T)((CalculusFieldElement)this.getAlphaM().add(this.raan));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)this.getAlphaMDot().add(this.raanDot) : null);
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T equEx = this.getEquinoctialEx();
        T equEy = this.getEquinoctialEy();
        T hx = this.getHx();
        T hy = this.getHy();
        T lE = this.getLE();
        CalculusFieldElement hx2 = (CalculusFieldElement)hx.multiply(hx);
        CalculusFieldElement hy2 = (CalculusFieldElement)hy.multiply(hy);
        CalculusFieldElement factH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)).reciprocal();
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).subtract((FieldElement)hy2)).multiply((FieldElement)factH);
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx.multiply(2)).multiply(hy)).multiply((FieldElement)factH);
        CalculusFieldElement uz = (CalculusFieldElement)((CalculusFieldElement)hy.multiply(-2)).multiply((FieldElement)factH);
        CalculusFieldElement vx = uy;
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hy2.subtract((FieldElement)hx2)).add(1.0)).multiply((FieldElement)factH);
        CalculusFieldElement vz = (CalculusFieldElement)((CalculusFieldElement)hx.multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement exey = (CalculusFieldElement)equEx.multiply(equEy);
        CalculusFieldElement ex2 = (CalculusFieldElement)equEx.multiply(equEx);
        CalculusFieldElement ey2 = (CalculusFieldElement)equEy.multiply(equEy);
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement eta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt()).add(1.0);
        CalculusFieldElement beta = (CalculusFieldElement)eta.reciprocal();
        FieldSinCos scLe = FastMath.sinCos(lE);
        CalculusFieldElement cLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement exCeyS = (CalculusFieldElement)((CalculusFieldElement)equEx.multiply((FieldElement)cLe)).add(equEy.multiply((FieldElement)sLe));
        CalculusFieldElement x = (CalculusFieldElement)this.a.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.negate()).multiply((FieldElement)ey2)).add(1.0)).multiply((FieldElement)cLe)).add(((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sLe))).subtract(equEx));
        CalculusFieldElement y = (CalculusFieldElement)this.a.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.negate()).multiply((FieldElement)ex2)).add(1.0)).multiply((FieldElement)sLe)).add(((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cLe))).subtract(equEy));
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.one.add(this.getMu())).divide(this.a)).sqrt()).divide(((CalculusFieldElement)exCeyS.negate()).add(1.0));
        CalculusFieldElement xdot = (CalculusFieldElement)factor.multiply(((CalculusFieldElement)((CalculusFieldElement)beta.multiply(equEy)).multiply((FieldElement)exCeyS)).subtract((FieldElement)sLe));
        CalculusFieldElement ydot = (CalculusFieldElement)factor.multiply(cLe.subtract(((CalculusFieldElement)beta.multiply(equEx)).multiply((FieldElement)exCeyS)));
        FieldVector3D position = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ux)).add(y.multiply((FieldElement)vx)), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uy)).add(y.multiply((FieldElement)vy)), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uz)).add(y.multiply((FieldElement)vz)));
        FieldVector3D velocity = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)ux)).add(ydot.multiply((FieldElement)vx)), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uy)).add(ydot.multiply((FieldElement)vy)), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uz)).add(ydot.multiply((FieldElement)vz)));
        this.partialPV = new FieldPVCoordinates(position, velocity);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        CalculusFieldElement[][] dCdP = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        CalculusFieldElement nonKeplerianMeanMotion = (CalculusFieldElement)this.getAlphaMDot().subtract(this.getKeplerianMeanMotion());
        CalculusFieldElement nonKeplerianAx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.exDot))).add(dCdP[3][2].multiply(this.eyDot))).add(dCdP[3][3].multiply(this.iDot))).add(dCdP[3][4].multiply(this.raanDot))).add(dCdP[3][5].multiply((FieldElement)nonKeplerianMeanMotion));
        CalculusFieldElement nonKeplerianAy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.exDot))).add(dCdP[4][2].multiply(this.eyDot))).add(dCdP[4][3].multiply(this.iDot))).add(dCdP[4][4].multiply(this.raanDot))).add(dCdP[4][5].multiply((FieldElement)nonKeplerianMeanMotion));
        CalculusFieldElement nonKeplerianAz = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.exDot))).add(dCdP[5][2].multiply(this.eyDot))).add(dCdP[5][3].multiply(this.iDot))).add(dCdP[5][4].multiply(this.raanDot))).add(dCdP[5][5].multiply((FieldElement)nonKeplerianMeanMotion));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        CalculusFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(T dt) {
        FieldCircularOrbit<CalculusFieldElement> keplerianShifted = new FieldCircularOrbit<CalculusFieldElement>((CalculusFieldElement)this.a, (CalculusFieldElement)this.ex, (CalculusFieldElement)this.ey, (CalculusFieldElement)this.i, (CalculusFieldElement)this.raan, (CalculusFieldElement)this.getAlphaM().add(this.getKeplerianMeanMotion().multiply(dt)), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (CalculusFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.one, keplerianShifted.partialPV.getPosition(), (CalculusFieldElement)((CalculusFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR2.multiply((FieldElement)fixedR)).reciprocal()).multiply(this.getMu().negate()), keplerianShifted.partialPV.getPosition(), this.one, nonKeplerianAcceleration);
            return new FieldCircularOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldCircularOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousRAAN = (CalculusFieldElement)this.zero.add(Double.NaN);
        Object previousAlphaM = (CalculusFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousAlphaM;
            Object continuousRAAN;
            FieldCircularOrbit circ = (FieldCircularOrbit)OrbitType.CIRCULAR.convertType(orbit);
            if (previousDate == null) {
                continuousRAAN = circ.getRightAscensionOfAscendingNode();
                continuousAlphaM = circ.getAlphaM();
            } else {
                Object dt = circ.getDate().durationFrom(previousDate);
                CalculusFieldElement keplerAM = (CalculusFieldElement)previousAlphaM.add(circ.getKeplerianMeanMotion().multiply(dt));
                continuousRAAN = MathUtils.normalizeAngle(circ.getRightAscensionOfAscendingNode(), (CalculusFieldElement)previousRAAN);
                continuousAlphaM = MathUtils.normalizeAngle(circ.getAlphaM(), (CalculusFieldElement)keplerAM);
            }
            previousDate = circ.getDate();
            previousRAAN = continuousRAAN;
            previousAlphaM = continuousAlphaM;
            CalculusFieldElement[] toAdd = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
            toAdd[0] = circ.getA();
            toAdd[1] = circ.getCircularEx();
            toAdd[2] = circ.getCircularEy();
            toAdd[3] = circ.getI();
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousAlphaM;
            if (useDerivatives) {
                CalculusFieldElement[] toAddDot = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = circ.getADot();
                toAddDot[1] = circ.getCircularExDot();
                toAddDot[2] = circ.getCircularEyDot();
                toAddDot[3] = circ.getIDot();
                toAddDot[4] = circ.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = circ.getAlphaMDot();
                interpolator.addSamplePoint(circ.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(circ.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{toAdd});
        }
        CalculusFieldElement[][] interpolated = (CalculusFieldElement[][])interpolator.derivatives(this.zero, 1);
        return new FieldCircularOrbit<CalculusFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)date, (CalculusFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.one.getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        CalculusFieldElement x = position.getX();
        CalculusFieldElement y = position.getY();
        CalculusFieldElement z = position.getZ();
        CalculusFieldElement vx = velocity.getX();
        CalculusFieldElement vy = velocity.getY();
        CalculusFieldElement vz = velocity.getZ();
        CalculusFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement v2 = velocity.getNormSq();
        Object mu = this.getMu();
        CalculusFieldElement oOsqrtMuA = (CalculusFieldElement)this.one.divide(((CalculusFieldElement)this.a.multiply(mu)).sqrt());
        CalculusFieldElement rOa = (CalculusFieldElement)r.divide(this.a);
        CalculusFieldElement aOr = (CalculusFieldElement)this.a.divide((FieldElement)r);
        CalculusFieldElement aOr2 = (CalculusFieldElement)this.a.divide((FieldElement)r2);
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.multiply(this.a);
        CalculusFieldElement ex2 = (CalculusFieldElement)this.ex.multiply(this.ex);
        CalculusFieldElement ey2 = (CalculusFieldElement)this.ey.multiply(this.ey);
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt();
        CalculusFieldElement beta = (CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).reciprocal();
        CalculusFieldElement eCosE = (CalculusFieldElement)((CalculusFieldElement)rOa.negate()).add(1.0);
        CalculusFieldElement eSinE = (CalculusFieldElement)pv.multiply((FieldElement)oOsqrtMuA);
        FieldSinCos scI = FastMath.sinCos(this.i);
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement cosRaan = (CalculusFieldElement)scRaan.cos();
        CalculusFieldElement sinRaan = (CalculusFieldElement)scRaan.sin();
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)aOr.multiply(2.0)).multiply((FieldElement)aOr2), position, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)a2.multiply(((CalculusFieldElement)mu.divide(2.0)).reciprocal()), velocity, jacobian[0], 3);
        FieldVector3D danP = new FieldVector3D(v2, position, (CalculusFieldElement)pv.negate(), velocity);
        FieldVector3D danV = new FieldVector3D(r2, velocity, (CalculusFieldElement)pv.negate(), position);
        CalculusFieldElement recip = (CalculusFieldElement)this.partialPV.getMomentum().getNorm().reciprocal();
        CalculusFieldElement recip2 = (CalculusFieldElement)recip.multiply((FieldElement)recip);
        CalculusFieldElement recip2N = (CalculusFieldElement)recip2.negate();
        FieldVector3D dwXP = new FieldVector3D(recip, new FieldVector3D(this.zero, vz, (CalculusFieldElement)vy.negate()), (CalculusFieldElement)((CalculusFieldElement)recip2N.multiply((FieldElement)sinRaan)).multiply((FieldElement)sinI), danP);
        FieldVector3D dwYP = new FieldVector3D(recip, new FieldVector3D((CalculusFieldElement)vz.negate(), this.zero, vx), (CalculusFieldElement)((CalculusFieldElement)recip2.multiply((FieldElement)cosRaan)).multiply((FieldElement)sinI), danP);
        FieldVector3D dwZP = new FieldVector3D(recip, new FieldVector3D(vy, (CalculusFieldElement)vx.negate(), this.zero), (CalculusFieldElement)recip2N.multiply((FieldElement)cosI), danP);
        FieldVector3D dwXV = new FieldVector3D(recip, new FieldVector3D(this.zero, (CalculusFieldElement)z.negate(), y), (CalculusFieldElement)((CalculusFieldElement)recip2N.multiply((FieldElement)sinRaan)).multiply((FieldElement)sinI), danV);
        FieldVector3D dwYV = new FieldVector3D(recip, new FieldVector3D(z, this.zero, (CalculusFieldElement)x.negate()), (CalculusFieldElement)((CalculusFieldElement)recip2.multiply((FieldElement)cosRaan)).multiply((FieldElement)sinI), danV);
        FieldVector3D dwZV = new FieldVector3D(recip, new FieldVector3D((CalculusFieldElement)y.negate(), x, this.zero), (CalculusFieldElement)recip2N.multiply((FieldElement)cosI), danV);
        this.fillHalfRow((CalculusFieldElement)sinRaan.multiply((FieldElement)cosI), dwXP, (CalculusFieldElement)((CalculusFieldElement)cosRaan.negate()).multiply((FieldElement)cosI), dwYP, (CalculusFieldElement)sinI.negate(), dwZP, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)sinRaan.multiply((FieldElement)cosI), dwXV, (CalculusFieldElement)((CalculusFieldElement)cosRaan.negate()).multiply((FieldElement)cosI), dwYV, (CalculusFieldElement)sinI.negate(), dwZV, jacobian[3], 3);
        this.fillHalfRow((CalculusFieldElement)sinRaan.divide((FieldElement)sinI), dwYP, (CalculusFieldElement)cosRaan.divide((FieldElement)sinI), dwXP, jacobian[4], 0);
        this.fillHalfRow((CalculusFieldElement)sinRaan.divide((FieldElement)sinI), dwYV, (CalculusFieldElement)cosRaan.divide((FieldElement)sinI), dwXV, jacobian[4], 3);
        CalculusFieldElement u = (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)cosRaan)).add(y.multiply((FieldElement)sinRaan));
        CalculusFieldElement cv = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.negate()).multiply((FieldElement)sinRaan)).add(y.multiply((FieldElement)cosRaan));
        CalculusFieldElement v = (CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)cosI)).add(z.multiply((FieldElement)sinI));
        FieldVector3D duP = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)cosRaan)).divide((FieldElement)sinI), dwXP, (CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)sinRaan)).divide((FieldElement)sinI), dwYP, this.one, new FieldVector3D(cosRaan, sinRaan, this.zero));
        FieldVector3D duV = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)cosRaan)).divide((FieldElement)sinI), dwXV, (CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)sinRaan)).divide((FieldElement)sinI), dwYV);
        FieldVector3D dvP = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)cosRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).add(sinRaan.multiply((FieldElement)z)), dwXP, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)sinRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).subtract(cosRaan.multiply((FieldElement)z)), dwYP, cv, dwZP, this.one, new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sinRaan.negate()).multiply((FieldElement)cosI), (CalculusFieldElement)cosRaan.multiply((FieldElement)cosI), sinI));
        FieldVector3D dvV = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)cosRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).add(sinRaan.multiply((FieldElement)z)), dwXV, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)sinRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).subtract(cosRaan.multiply((FieldElement)z)), dwYV, cv, dwZV);
        FieldVector3D dc1P = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)).multiply(2)).add(1.0)).subtract((FieldElement)eCosE))).divide((FieldElement)r2), position, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(-2)).multiply((FieldElement)eSinE)).multiply((FieldElement)oOsqrtMuA), velocity);
        FieldVector3D dc1V = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(-2)).multiply((FieldElement)eSinE)).multiply((FieldElement)oOsqrtMuA), position, (CalculusFieldElement)((CalculusFieldElement)this.zero.add(2.0)).divide(mu), velocity);
        FieldVector3D dc2P = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)eSinE)).multiply(((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)).subtract(((CalculusFieldElement)e2.negate()).add(1.0)))).divide(r2.multiply((FieldElement)epsilon)), position, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).subtract(eSinE.multiply((FieldElement)eSinE)))).multiply((FieldElement)oOsqrtMuA)).divide((FieldElement)epsilon), velocity);
        FieldVector3D dc2V = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).subtract(eSinE.multiply((FieldElement)eSinE)))).multiply((FieldElement)oOsqrtMuA)).divide((FieldElement)epsilon), position, (CalculusFieldElement)eSinE.divide(epsilon.multiply(mu)), velocity);
        CalculusFieldElement cof1 = (CalculusFieldElement)aOr2.multiply(eCosE.subtract((FieldElement)e2));
        CalculusFieldElement cof2 = (CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)epsilon)).multiply((FieldElement)eSinE);
        FieldVector3D dexP = new FieldVector3D(u, dc1P, v, dc2P, cof1, duP, cof2, dvP);
        FieldVector3D dexV = new FieldVector3D(u, dc1V, v, dc2V, cof1, duV, cof2, dvV);
        FieldVector3D deyP = new FieldVector3D(v, dc1P, (CalculusFieldElement)u.negate(), dc2P, cof1, dvP, (CalculusFieldElement)cof2.negate(), duP);
        FieldVector3D deyV = new FieldVector3D(v, dc1V, (CalculusFieldElement)u.negate(), dc2V, cof1, dvV, (CalculusFieldElement)cof2.negate(), duV);
        this.fillHalfRow((CalculusFieldElement)this.one, dexP, jacobian[1], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, dexV, jacobian[1], 3);
        this.fillHalfRow((CalculusFieldElement)this.one, deyP, jacobian[2], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, deyV, jacobian[2], 3);
        CalculusFieldElement cle = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.divide(this.a)).add(this.ex)).subtract(((CalculusFieldElement)eSinE.multiply((FieldElement)beta)).multiply(this.ey));
        CalculusFieldElement sle = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v.divide(this.a)).add(this.ey)).add(((CalculusFieldElement)eSinE.multiply((FieldElement)beta)).multiply(this.ex));
        CalculusFieldElement m1 = (CalculusFieldElement)beta.multiply((FieldElement)eCosE);
        CalculusFieldElement m2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)eCosE)).negate()).add(1.0);
        CalculusFieldElement m3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.multiply(this.ey)).subtract(v.multiply(this.ex))).add(((CalculusFieldElement)eSinE.multiply((FieldElement)beta)).multiply(((CalculusFieldElement)u.multiply(this.ex)).add(v.multiply(this.ey))));
        CalculusFieldElement m4 = (CalculusFieldElement)((CalculusFieldElement)sle.negate()).add(((CalculusFieldElement)cle.multiply((FieldElement)eSinE)).multiply((FieldElement)beta));
        CalculusFieldElement m5 = (CalculusFieldElement)cle.add(((CalculusFieldElement)sle.multiply((FieldElement)eSinE)).multiply((FieldElement)beta));
        CalculusFieldElement kk = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m3.multiply(2)).divide((FieldElement)r)).add(aOr.multiply((FieldElement)eSinE))).add(((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)eSinE)).multiply(((CalculusFieldElement)m1.add(1.0)).subtract(((CalculusFieldElement)aOr.add(1.0)).multiply((FieldElement)m2)))).divide((FieldElement)epsilon))).divide((FieldElement)r2);
        CalculusFieldElement jj = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)m2)).divide((FieldElement)epsilon)).subtract(1.0)).multiply((FieldElement)oOsqrtMuA);
        this.fillHalfRow(kk, position, jj, velocity, m4, dexP, m5, deyP, (CalculusFieldElement)((CalculusFieldElement)sle.negate()).divide(this.a), duP, (CalculusFieldElement)cle.divide(this.a), dvP, jacobian[5], 0);
        CalculusFieldElement ll = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)m2)).divide((FieldElement)epsilon)).subtract(1.0)).multiply((FieldElement)oOsqrtMuA);
        CalculusFieldElement mm = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m3.multiply(2)).add(eSinE.multiply(this.a))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)eSinE)).multiply((FieldElement)r)).multiply(((CalculusFieldElement)((CalculusFieldElement)eCosE.multiply((FieldElement)beta)).multiply(2)).subtract(aOr.multiply((FieldElement)m2)))).divide((FieldElement)epsilon))).divide(mu);
        this.fillHalfRow(ll, position, mm, velocity, m4, dexV, m5, deyV, (CalculusFieldElement)((CalculusFieldElement)sle.negate()).divide(this.a), duV, (CalculusFieldElement)cle.divide(this.a), dvV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        T alphaE = this.getAlphaE();
        FieldSinCos scAe = FastMath.sinCos(alphaE);
        CalculusFieldElement cosAe = (CalculusFieldElement)scAe.cos();
        CalculusFieldElement sinAe = (CalculusFieldElement)scAe.sin();
        CalculusFieldElement aOr = (CalculusFieldElement)this.one.divide(((CalculusFieldElement)this.one.subtract(this.ex.multiply((FieldElement)cosAe))).subtract(this.ey.multiply((FieldElement)sinAe)));
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (CalculusFieldElement)aOr.multiply(((CalculusFieldElement)rowL[j].add(sinAe.multiply((FieldElement)rowEx[j]))).subtract(cosAe.multiply((FieldElement)rowEy[j])));
        }
        jacobian[5] = rowL;
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        T alphaE = this.getAlphaE();
        FieldSinCos scAe = FastMath.sinCos(alphaE);
        CalculusFieldElement cosAe = (CalculusFieldElement)scAe.cos();
        CalculusFieldElement sinAe = (CalculusFieldElement)scAe.sin();
        CalculusFieldElement eSinE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sinAe)).subtract(this.ey.multiply((FieldElement)cosAe));
        CalculusFieldElement ecosE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cosAe)).add(this.ey.multiply((FieldElement)sinAe));
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract((FieldElement)e2)).sqrt();
        CalculusFieldElement onePeps = (CalculusFieldElement)this.one.add((FieldElement)epsilon);
        CalculusFieldElement d = (CalculusFieldElement)onePeps.subtract((FieldElement)ecosE);
        CalculusFieldElement cT = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)).add(eSinE.multiply((FieldElement)eSinE))).divide(2.0);
        CalculusFieldElement cE = (CalculusFieldElement)((CalculusFieldElement)ecosE.multiply((FieldElement)onePeps)).subtract((FieldElement)e2);
        CalculusFieldElement cX = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).subtract(this.ey)).add(sinAe.multiply((FieldElement)onePeps));
        CalculusFieldElement cY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).add(this.ex)).subtract(cosAe.multiply((FieldElement)onePeps));
        CalculusFieldElement factorLe = (CalculusFieldElement)((CalculusFieldElement)cT.add((FieldElement)cE)).divide((FieldElement)cT);
        CalculusFieldElement factorEx = (CalculusFieldElement)cX.divide((FieldElement)cT);
        CalculusFieldElement factorEy = (CalculusFieldElement)cY.divide((FieldElement)cT);
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowA = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowA[j] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorLe.multiply((FieldElement)rowA[j])).add(factorEx.multiply((FieldElement)rowEx[j]))).add(factorEy.multiply((FieldElement)rowEy[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.reciprocal()).multiply(gm)).sqrt()).divide(this.a);
        FieldSinCos sc = FastMath.sinCos(this.alphaV);
        switch (type) {
            case MEAN: {
                pDot[5] = (CalculusFieldElement)pDot[5].add((FieldElement)n);
                break;
            }
            case ECCENTRIC: {
                CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)this.one.add(this.ex.multiply((FieldElement)sc.cos()))).add(this.ey.multiply((FieldElement)sc.sin()));
                pDot[5] = (CalculusFieldElement)pDot[5].add(((CalculusFieldElement)n.multiply((FieldElement)ksi)).divide((FieldElement)oMe2));
                break;
            }
            case TRUE: {
                CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)this.one.add(this.ex.multiply((FieldElement)sc.cos()))).add(this.ey.multiply((FieldElement)sc.sin()));
                pDot[5] = (CalculusFieldElement)pDot[5].add(((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)ksi)).multiply((FieldElement)ksi)).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return "circular parameters: " + '{' + "a: " + this.a.getReal() + ", ex: " + this.ex.getReal() + ", ey: " + this.ey.getReal() + ", i: " + FastMath.toDegrees((double)this.i.getReal()) + ", raan: " + FastMath.toDegrees((double)this.raan.getReal()) + ", alphaV: " + FastMath.toDegrees((double)this.alphaV.getReal()) + ";}";
    }

    @Override
    public CircularOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), this.alphaV.getReal(), this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.iDot.getReal(), this.raanDot.getReal(), this.alphaVDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), this.alphaV.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

