/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTHarvester;
import org.orekit.propagation.semianalytical.dsst.DSSTJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTPartialDerivativesEquations;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.utils.ParameterDriversList;

public class DSSTBatchLSModel
extends AbstractBatchLSModel {
    private static final String STM_NAME = DSSTBatchLSModel.class.getName() + "-derivatives";
    private PropagationType propagationType;
    private PropagationType stateType;

    public DSSTBatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer, PropagationType propagationType, PropagationType stateType) {
        super(propagatorBuilders, measurements, estimatedMeasurementsParameters, observer);
        this.propagationType = propagationType;
        this.stateType = stateType;
    }

    @Override
    protected MatricesHarvester configureHarvester(Propagator propagator) {
        return propagator.setupMatricesComputation(STM_NAME, null, null);
    }

    @Override
    @Deprecated
    protected DSSTJacobiansMapper configureDerivatives(Propagator propagator) {
        DSSTPartialDerivativesEquations partials = new DSSTPartialDerivativesEquations(STM_NAME, (DSSTPropagator)propagator, this.propagationType);
        SpacecraftState rawState = propagator.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        ((DSSTPropagator)propagator).setInitialState(stateWithDerivatives, this.stateType);
        return partials.getMapper();
    }

    @Override
    protected Orbit configureOrbits(MatricesHarvester harvester, Propagator propagator) {
        DSSTPropagator dsstPropagator = (DSSTPropagator)propagator;
        DSSTHarvester dsstHarvester = (DSSTHarvester)harvester;
        SpacecraftState initial = dsstPropagator.initialIsOsculating() ? DSSTPropagator.computeMeanState(dsstPropagator.getInitialState(), dsstPropagator.getAttitudeProvider(), dsstPropagator.getAllForceModels()) : dsstPropagator.getInitialState();
        dsstHarvester.initializeFieldShortPeriodTerms(initial);
        if (this.propagationType == PropagationType.OSCULATING) {
            dsstHarvester.updateFieldShortPeriodTerms(initial);
            dsstHarvester.setReferenceState(initial);
        }
        harvester.setReferenceState(initial);
        return initial.getOrbit();
    }
}

