/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.orekit.bodies.CR3BPSystem;
import org.orekit.orbits.CR3BPDifferentialCorrection;
import org.orekit.orbits.LibrationOrbit;
import org.orekit.orbits.LibrationOrbitFamily;
import org.orekit.orbits.LibrationOrbitType;
import org.orekit.orbits.RichardsonExpansion;
import org.orekit.utils.PVCoordinates;

public class HaloOrbit
extends LibrationOrbit {
    public HaloOrbit(CR3BPSystem syst, PVCoordinates pv, double orbitalPeriod) {
        super(syst, pv, orbitalPeriod);
    }

    public HaloOrbit(RichardsonExpansion richardson, double az, LibrationOrbitFamily type) {
        super(richardson.getCr3bpSystem(), richardson.computeHaloFirstGuess(az, type, 0.0, 0.0), richardson.getHaloOrbitalPeriod(az));
    }

    @Override
    protected PVCoordinates applyCorrectionOnPV(CR3BPDifferentialCorrection diff) {
        return diff.compute(LibrationOrbitType.HALO);
    }
}

