/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.CalculusFieldElement;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.ITRFProvider;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

class VersionedITRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20180403L;
    private final ITRFVersion version;
    private final ITRFProvider rawProvider;
    private final AtomicReference<ITRFVersion.Converter> converter;
    private final TimeScale tt;

    VersionedITRFProvider(ITRFVersion version, ITRFProvider rawProvider, TimeScale tt) {
        this.version = version;
        this.rawProvider = rawProvider;
        this.converter = new AtomicReference();
        this.tt = tt;
    }

    public ITRFVersion getITRFVersion() {
        return this.version;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.rawProvider.getEOPHistory();
    }

    @Override
    public VersionedITRFProvider getNonInterpolatingProvider() {
        return new VersionedITRFProvider(this.version, this.rawProvider.getNonInterpolatingProvider(), this.tt);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        Transform rawTransform = this.rawProvider.getTransform(date);
        ITRFVersion.Converter converterForDate = this.getConverter(date);
        if (converterForDate == null) {
            return rawTransform;
        }
        return new Transform(date, rawTransform, converterForDate.getTransform(date));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        FieldTransform<T> rawTransform = this.rawProvider.getTransform(date);
        ITRFVersion.Converter converterForDate = this.getConverter(date.toAbsoluteDate());
        if (converterForDate == null) {
            return rawTransform;
        }
        return new FieldTransform<T>(date, rawTransform, converterForDate.getTransform(date));
    }

    private ITRFVersion.Converter getConverter(AbsoluteDate date) {
        ITRFVersion rawVersion = this.getEOPHistory().getITRFVersion(date);
        if (rawVersion == this.version) {
            return null;
        }
        ITRFVersion.Converter existing = this.converter.get();
        if (existing != null && existing.getOrigin() == rawVersion) {
            return existing;
        }
        ITRFVersion.Converter newConverter = ITRFVersion.getConverter(rawVersion, this.version, this.tt);
        this.converter.compareAndSet(null, newConverter);
        return newConverter;
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.version, this.rawProvider);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20180403L;
        private final ITRFVersion version;
        private final ITRFProvider rawProvider;

        DataTransferObject(ITRFVersion version, ITRFProvider rawProvider) {
            this.version = version;
            this.rawProvider = rawProvider;
        }

        private Object readResolve() {
            return new VersionedITRFProvider(this.version, this.rawProvider, DataContext.getDefault().getTimeScales().getTT());
        }
    }
}

