/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldInterpolationGrid;

public class FieldMaxGapInterpolationGrid<T extends CalculusFieldElement<T>>
implements FieldInterpolationGrid<T> {
    private final T maxGap;
    private final Field<T> field;

    public FieldMaxGapInterpolationGrid(Field<T> field, T maxGap) {
        this.field = field;
        this.maxGap = maxGap;
    }

    @Override
    public T[] getGridPoints(T stepStart, T stepEnd) {
        int pointsPerStep = FastMath.max((int)2, (int)((int)FastMath.ceil((double)(FastMath.abs((double)(stepEnd.getReal() - stepStart.getReal())) / this.maxGap.getReal()))));
        CalculusFieldElement[] grid = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)pointsPerStep);
        CalculusFieldElement stepSize = (CalculusFieldElement)((CalculusFieldElement)stepEnd.subtract(stepStart)).divide((double)pointsPerStep - 1.0);
        for (int i = 0; i < pointsPerStep; ++i) {
            grid[i] = (CalculusFieldElement)((CalculusFieldElement)stepSize.multiply(i)).add(stepStart);
        }
        return grid;
    }
}

