/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndoints;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionKey;
import org.orekit.files.ccsds.section.Section;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class ApmQuaternion
implements Section {
    private AbsoluteDate epoch;
    private final AttitudeEndoints endpoints = new AttitudeEndoints();
    private double[] q = new double[4];
    private double[] qDot = new double[4];

    public ApmQuaternion() {
        Arrays.fill(this.q, Double.NaN);
        Arrays.fill(this.qDot, Double.NaN);
    }

    @Override
    public void validate(double version) {
        this.endpoints.checkMandatoryEntriesExceptExternalFrame(ApmQuaternionKey.Q_FRAME_A, ApmQuaternionKey.Q_FRAME_B, ApmQuaternionKey.Q_DIR);
        this.endpoints.checkExternalFrame(ApmQuaternionKey.Q_FRAME_A, ApmQuaternionKey.Q_FRAME_B);
        if (Double.isNaN(this.q[0] + this.q[1] + this.q[2] + this.q[3])) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "Q{C|1|2|3}");
        }
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public AttitudeEndoints getEndpoints() {
        return this.endpoints;
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this.q[0], this.q[1], this.q[2], this.q[3]);
    }

    public void setQ(int index, double value) {
        this.q[index] = value;
    }

    public Quaternion getQuaternionDot() {
        return new Quaternion(this.qDot[0], this.qDot[1], this.qDot[2], this.qDot[3]);
    }

    public void setQDot(int index, double derivative) {
        this.qDot[index] = derivative;
    }

    public boolean hasRates() {
        return !Double.isNaN(this.qDot[0] + this.qDot[1] + this.qDot[2] + this.qDot[3]);
    }

    public Attitude getAttitude(Frame frame, PVCoordinatesProvider pvProvider) {
        if (Double.isNaN(this.qDot[0])) {
            Rotation r = new Rotation(this.q[0], this.q[1], this.q[2], this.q[3], true);
            return this.endpoints.build(frame, pvProvider, new TimeStampedAngularCoordinates(this.epoch, r, Vector3D.ZERO, Vector3D.ZERO));
        }
        UnivariateDerivative1 q0 = new UnivariateDerivative1(this.q[0], this.qDot[0]);
        UnivariateDerivative1 q1 = new UnivariateDerivative1(this.q[1], this.qDot[1]);
        UnivariateDerivative1 q2 = new UnivariateDerivative1(this.q[2], this.qDot[2]);
        UnivariateDerivative1 q3 = new UnivariateDerivative1(this.q[3], this.qDot[3]);
        FieldRotation rd = new FieldRotation((CalculusFieldElement)q0, (CalculusFieldElement)q1, (CalculusFieldElement)q2, (CalculusFieldElement)q3, true);
        return this.endpoints.build(frame, pvProvider, new TimeStampedAngularCoordinates(this.epoch, rd));
    }
}

