/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.UnitsConverter;

class RapidDataAndPredictionColumnsLoader
extends AbstractEopLoader
implements EOPHistoryLoader {
    private static final String INTEGER2_FIELD = "((?:\\p{Blank}|\\p{Digit})\\p{Digit})";
    private static final String MJD_FIELD = "\\p{Blank}+(\\p{Digit}+)(?:\\.00*)";
    private static final String SEPARATOR = "\\p{Blank}*[IP]";
    private static final String REAL_FIELD = "\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)";
    private static int DATE_START = 0;
    private static int DATE_END = 15;
    private static final Pattern DATE_PATTERN = Pattern.compile("((?:\\p{Blank}|\\p{Digit})\\p{Digit})((?:\\p{Blank}|\\p{Digit})\\p{Digit})((?:\\p{Blank}|\\p{Digit})\\p{Digit})\\p{Blank}+(\\p{Digit}+)(?:\\.00*)");
    private static int POLE_START = 16;
    private static int POLE_END = 55;
    private static final Pattern POLE_PATTERN = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int UT1_UTC_START = 57;
    private static int UT1_UTC_END = 78;
    private static final Pattern UT1_UTC_PATTERN = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int LOD_START = 79;
    private static int LOD_END = 93;
    private static final Pattern LOD_PATTERN = Pattern.compile("\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int NUTATION_START = 95;
    private static int NUTATION_END = 134;
    private static final Pattern NUTATION_PATTERN = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private final boolean isNonRotatingOrigin;

    RapidDataAndPredictionColumnsLoader(boolean isNonRotatingOrigin, String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
        this.isNonRotatingOrigin = isNonRotatingOrigin;
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        ITRFVersionLoader itrfVersionProvider = new ITRFVersionLoader("itrf-versions.conf", this.getDataProvidersManager());
        Parser parser = new Parser(converter, itrfVersionProvider, this.getUtc(), this.isNonRotatingOrigin);
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    static class Parser
    extends AbstractEopParser {
        private final boolean isNonRotatingOrigin;

        Parser(IERSConventions.NutationCorrectionConverter converter, ItrfVersionProvider itrfVersionProvider, TimeScale utc, boolean isNonRotatingOrigin) {
            super(converter, itrfVersionProvider, utc);
            this.isNonRotatingOrigin = isNonRotatingOrigin;
        }

        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException {
            ArrayList<EOPEntry> history = new ArrayList<EOPEntry>();
            ITRFVersionLoader.ITRFVersionConfiguration configuration = null;
            int lineNumber = 0;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    double[] equinox;
                    double[] nro;
                    double lod;
                    double dtu1;
                    double y;
                    double x;
                    int mjd;
                    ++lineNumber;
                    String datePart = line.length() >= DATE_END ? line.substring(DATE_START, DATE_END) : "";
                    String polePart = line.length() >= POLE_END ? line.substring(POLE_START, POLE_END) : "";
                    String ut1utcPart = line.length() >= UT1_UTC_END ? line.substring(UT1_UTC_START, UT1_UTC_END) : "";
                    String lodPart = line.length() >= LOD_END ? line.substring(LOD_START, LOD_END) : "";
                    String nutationPart = line.length() >= NUTATION_END ? line.substring(NUTATION_START, NUTATION_END) : "";
                    Matcher dateMatcher = DATE_PATTERN.matcher(datePart);
                    if (dateMatcher.matches()) {
                        int yy = Integer.parseInt(dateMatcher.group(1).trim());
                        int mm = Integer.parseInt(dateMatcher.group(2).trim());
                        int dd = Integer.parseInt(dateMatcher.group(3).trim());
                        mjd = Integer.parseInt(dateMatcher.group(4).trim());
                        DateComponents reconstructedDate = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
                        if (reconstructedDate.getYear() % 100 != yy || reconstructedDate.getMonth() != mm || reconstructedDate.getDay() != dd) {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        }
                    } else {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    if (polePart.trim().length() == 0) {
                        x = 0.0;
                        y = 0.0;
                    } else {
                        Matcher poleMatcher = POLE_PATTERN.matcher(polePart);
                        if (poleMatcher.matches()) {
                            x = UnitsConverter.ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(poleMatcher.group(1)));
                            y = UnitsConverter.ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(poleMatcher.group(3)));
                        } else {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        }
                    }
                    if (ut1utcPart.trim().length() == 0) {
                        dtu1 = 0.0;
                    } else {
                        Matcher ut1utcMatcher = UT1_UTC_PATTERN.matcher(ut1utcPart);
                        if (ut1utcMatcher.matches()) {
                            dtu1 = Double.parseDouble(ut1utcMatcher.group(1));
                        } else {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        }
                    }
                    if (lodPart.trim().length() == 0) {
                        lod = 0.0;
                    } else {
                        Matcher lodMatcher = LOD_PATTERN.matcher(lodPart);
                        if (lodMatcher.matches()) {
                            lod = UnitsConverter.MILLI_SECONDS_TO_SECONDS.convert(Double.parseDouble(lodMatcher.group(1)));
                        } else {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        }
                    }
                    AbsoluteDate mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), this.getUtc());
                    if (nutationPart.trim().length() == 0) {
                        nro = new double[2];
                        equinox = new double[2];
                    } else {
                        Matcher nutationMatcher = NUTATION_PATTERN.matcher(nutationPart);
                        if (nutationMatcher.matches()) {
                            if (this.isNonRotatingOrigin) {
                                nro = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationMatcher.group(1))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationMatcher.group(3)))};
                                equinox = this.getConverter().toEquinox(mjdDate, nro[0], nro[1]);
                            } else {
                                equinox = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationMatcher.group(1))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationMatcher.group(3)))};
                                nro = this.getConverter().toNonRotating(mjdDate, equinox[0], equinox[1]);
                            }
                        } else {
                            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        }
                    }
                    if (configuration == null || !configuration.isValid(mjd)) {
                        configuration = this.getItrfVersionProvider().getConfiguration(name, mjd);
                    }
                    history.add(new EOPEntry(mjd, dtu1, lod, x, y, equinox[0], equinox[1], nro[0], nro[1], configuration.getVersion(), mjdDate));
                    line = reader.readLine();
                }
            }
            return history;
        }
    }
}

