/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.tdm.AngleType;
import org.orekit.files.ccsds.ndm.tdm.CorrectionApplied;
import org.orekit.files.ccsds.ndm.tdm.DataQuality;
import org.orekit.files.ccsds.ndm.tdm.IntegrationReference;
import org.orekit.files.ccsds.ndm.tdm.ObservationType;
import org.orekit.files.ccsds.ndm.tdm.RangeMode;
import org.orekit.files.ccsds.ndm.tdm.RangeUnits;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadata;
import org.orekit.files.ccsds.ndm.tdm.TimetagReference;
import org.orekit.files.ccsds.ndm.tdm.TrackingMode;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.utils.units.Unit;

public enum TdmMetadataKey {
    TRACK_ID((token, context, container) -> token.processAsNormalizedString(container::setTrackId)),
    DATA_TYPES((token, context, container) -> token.processAsEnumsList(ObservationType.class, container::setDataTypes)),
    START_TIME((token, context, container) -> token.processAsDate(container::setStartTime, context)),
    STOP_TIME((token, context, container) -> token.processAsDate(container::setStopTime, context)),
    PARTICIPANT_1((token, context, container) -> token.processAsIndexedNormalizedString(1, container::addParticipant)),
    PARTICIPANT_2((token, context, container) -> token.processAsIndexedNormalizedString(2, container::addParticipant)),
    PARTICIPANT_3((token, context, container) -> token.processAsIndexedNormalizedString(3, container::addParticipant)),
    PARTICIPANT_4((token, context, container) -> token.processAsIndexedNormalizedString(4, container::addParticipant)),
    PARTICIPANT_5((token, context, container) -> token.processAsIndexedNormalizedString(5, container::addParticipant)),
    MODE((token, context, container) -> token.processAsEnum(TrackingMode.class, container::setMode)),
    PATH((token, context, container) -> token.processAsIntegerArray(container::setPath)),
    PATH_1((token, context, container) -> token.processAsIntegerArray(container::setPath1)),
    PATH_2((token, context, container) -> token.processAsIntegerArray(container::setPath2)),
    EPHEMERIS_NAME_1((token, context, container) -> token.processAsIndexedNormalizedString(1, container::addEphemerisName)),
    EPHEMERIS_NAME_2((token, context, container) -> token.processAsIndexedNormalizedString(2, container::addEphemerisName)),
    EPHEMERIS_NAME_3((token, context, container) -> token.processAsIndexedNormalizedString(3, container::addEphemerisName)),
    EPHEMERIS_NAME_4((token, context, container) -> token.processAsIndexedNormalizedString(4, container::addEphemerisName)),
    EPHEMERIS_NAME_5((token, context, container) -> token.processAsIndexedNormalizedString(5, container::addEphemerisName)),
    TRANSMIT_BAND((token, context, container) -> token.processAsUppercaseString(container::setTransmitBand)),
    RECEIVE_BAND((token, context, container) -> token.processAsUppercaseString(container::setReceiveBand)),
    TURNAROUND_NUMERATOR((token, context, container) -> token.processAsInteger(container::setTurnaroundNumerator)),
    TURNAROUND_DENOMINATOR((token, context, container) -> token.processAsInteger(container::setTurnaroundDenominator)),
    TIMETAG_REF((token, context, container) -> token.processAsEnum(TimetagReference.class, container::setTimetagRef)),
    INTEGRATION_INTERVAL((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setIntegrationInterval)),
    INTEGRATION_REF((token, context, container) -> token.processAsEnum(IntegrationReference.class, container::setIntegrationRef)),
    FREQ_OFFSET((token, context, container) -> token.processAsDouble(Unit.HERTZ, context.getParsedUnitsBehavior(), container::setFreqOffset)),
    RANGE_MODE((token, context, container) -> token.processAsEnum(RangeMode.class, container::setRangeMode)),
    RANGE_MODULUS((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setRawRangeModulus)),
    RANGE_UNITS((token, context, container) -> token.processAsEnum(RangeUnits.class, container::setRangeUnits)),
    ANGLE_TYPE((token, context, container) -> token.processAsEnum(AngleType.class, container::setAngleType)),
    REFERENCE_FRAME((token, context, container) -> token.processAsFrame(container::setReferenceFrame, context, true, false, false)),
    INTERPOLATION((token, context, container) -> token.processAsUppercaseString(container::setInterpolationMethod)),
    INTERPOLATION_DEGREE((token, context, container) -> token.processAsInteger(container::setInterpolationDegree)),
    DOPPLER_COUNT_BIAS((token, context, container) -> token.processAsDouble(Unit.HERTZ, context.getParsedUnitsBehavior(), container::setDopplerCountBias)),
    DOPPLER_COUNT_SCALE((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setDopplerCountScale)),
    DOPPLER_COUNT_ROLLOVER((token, context, container) -> token.processAsBoolean(container::setDopplerCountRollover)),
    TRANSMIT_DELAY_1((token, context, container) -> token.processAsIndexedDouble(1, Unit.SECOND, context.getParsedUnitsBehavior(), container::addTransmitDelay)),
    TRANSMIT_DELAY_2((token, context, container) -> token.processAsIndexedDouble(2, Unit.SECOND, context.getParsedUnitsBehavior(), container::addTransmitDelay)),
    TRANSMIT_DELAY_3((token, context, container) -> token.processAsIndexedDouble(3, Unit.SECOND, context.getParsedUnitsBehavior(), container::addTransmitDelay)),
    TRANSMIT_DELAY_4((token, context, container) -> token.processAsIndexedDouble(4, Unit.SECOND, context.getParsedUnitsBehavior(), container::addTransmitDelay)),
    TRANSMIT_DELAY_5((token, context, container) -> token.processAsIndexedDouble(5, Unit.SECOND, context.getParsedUnitsBehavior(), container::addTransmitDelay)),
    RECEIVE_DELAY_1((token, context, container) -> token.processAsIndexedDouble(1, Unit.SECOND, context.getParsedUnitsBehavior(), container::addReceiveDelay)),
    RECEIVE_DELAY_2((token, context, container) -> token.processAsIndexedDouble(2, Unit.SECOND, context.getParsedUnitsBehavior(), container::addReceiveDelay)),
    RECEIVE_DELAY_3((token, context, container) -> token.processAsIndexedDouble(3, Unit.SECOND, context.getParsedUnitsBehavior(), container::addReceiveDelay)),
    RECEIVE_DELAY_4((token, context, container) -> token.processAsIndexedDouble(4, Unit.SECOND, context.getParsedUnitsBehavior(), container::addReceiveDelay)),
    RECEIVE_DELAY_5((token, context, container) -> token.processAsIndexedDouble(5, Unit.SECOND, context.getParsedUnitsBehavior(), container::addReceiveDelay)),
    DATA_QUALITY((token, context, container) -> token.processAsEnum(DataQuality.class, container::setDataQuality)),
    CORRECTION_ANGLE_1((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setCorrectionAngle1)),
    CORRECTION_ANGLE_2((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setCorrectionAngle2)),
    CORRECTION_DOPPLER((token, context, container) -> token.processAsDouble(Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setCorrectionDoppler)),
    CORRECTION_MAG((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setCorrectionMagnitude)),
    CORRECTION_RANGE((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setRawCorrectionRange)),
    CORRECTION_RCS((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setCorrectionRcs)),
    CORRECTION_RECEIVE((token, context, container) -> token.processAsDouble(Unit.HERTZ, context.getParsedUnitsBehavior(), container::setCorrectionReceive)),
    CORRECTION_TRANSMIT((token, context, container) -> token.processAsDouble(Unit.HERTZ, context.getParsedUnitsBehavior(), container::setCorrectionTransmit)),
    CORRECTION_ABERRATION_YEARLY((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setCorrectionAberrationYearly)),
    CORRECTION_ABERRATION_DIURNAL((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setCorrectionAberrationDiurnal)),
    CORRECTIONS_APPLIED((token, context, container) -> token.processAsEnum(CorrectionApplied.class, container::setCorrectionsApplied));

    private final TokenProcessor processor;

    private TdmMetadataKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, TdmMetadata container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, TdmMetadata var3);
    }
}

